<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\RedirectResponse;

class Doc extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $rows = [];
        try {
            $rows = $db->table('dokumentasi')->orderBy('id', 'DESC')->get()->getResultArray();
        } catch (\Throwable $e) {
            $rows = [];
        }

        return view('admin/doc/index', [
            'title' => 'Dokumentasi',
            'rows'  => $rows,
        ]);
    }

    public function form()
    {
        // Return partial form to be loaded inside modal
        return view('admin/doc/form', [
            'title' => 'Tambah Dokumentasi'
        ]);
    }

    public function store(): RedirectResponse
    {
        $desc  = trim((string)$this->request->getPost('desc'));
        $level = (int)($this->request->getPost('level') ?? 1);
        if ($desc === '') {
            return redirect()->back()->with('error', 'Deskripsi wajib diisi');
        }

        $fileName = '';
        $file = $this->request->getFile('file');
        if ($file && $file->isValid()) {
            $targetDir = FCPATH . 'uploads/doc';
            if (!is_dir($targetDir)) {
                @mkdir($targetDir, 0775, true);
            }
            $ext  = strtolower($file->getClientExtension() ?: pathinfo($file->getName(), PATHINFO_EXTENSION));
            $base = pathinfo($file->getName(), PATHINFO_FILENAME);
            $safe = preg_replace('~[^a-z0-9-_]+~i', '-', $base) ?: 'file';
            $new  = $safe . '-' . date('YmdHis') . '.' . $ext;
            if (!$file->move($targetDir, $new)) {
                return redirect()->back()->with('error', 'Gagal mengunggah file');
            }
            $fileName = 'uploads/doc/' . $new; // relative to public
        }

        try {
            db_connect()->table('dokumentasi')->insert([
                'desc'  => $desc,
                'file'  => $fileName,
                'level' => $level,
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', 'Gagal menyimpan data dokumentasi');
        }
        return redirect()->to(site_url('admin/doc'))->with('success', 'Berhasil menambahkan dokumentasi');
    }

    public function delete(int $id): RedirectResponse
    {
        $db = db_connect();
        try {
            $row = $db->table('dokumentasi')->where('id', $id)->get()->getRowArray();
            if ($row) {
                $db->table('dokumentasi')->where('id', $id)->delete();
                $file = (string)($row['file'] ?? '');
                if ($file !== '') {
                    $path = FCPATH . ltrim($file, '/');
                    if (is_file($path)) { @unlink($path); }
                }
            }
            return redirect()->back()->with('success', 'Berhasil menghapus dokumentasi');
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', 'Gagal menghapus dokumentasi');
        }
    }

    public function edit(int $id)
    {
        $db = db_connect();
        $row = $db->table('dokumentasi')->where('id', $id)->get()->getRowArray();
        if (!$row) {
            return '<div class="p-3 text-rose-600 text-sm">Data tidak ditemukan</div>';
        }
        return view('admin/doc/form_edit', [
            'title' => 'Ubah Dokumentasi',
            'row' => $row,
            'id'  => $id,
        ]);
    }

    public function update(int $id): RedirectResponse
    {
        $db = db_connect();
        $row = $db->table('dokumentasi')->where('id', $id)->get()->getRowArray();
        if (!$row) {
            return redirect()->back()->with('error', 'Data tidak ditemukan');
        }
        $desc  = trim((string)$this->request->getPost('desc'));
        $level = (int)($this->request->getPost('level') ?? 1);
        if ($desc === '') {
            return redirect()->back()->with('error', 'Deskripsi wajib diisi');
        }
        $data = [ 'desc' => $desc, 'level' => $level ];
        $file = $this->request->getFile('file');
        if ($file && $file->isValid()) {
            $targetDir = FCPATH . 'uploads/doc';
            if (!is_dir($targetDir)) { @mkdir($targetDir, 0775, true); }
            $ext  = strtolower($file->getClientExtension() ?: pathinfo($file->getName(), PATHINFO_EXTENSION));
            $base = pathinfo($file->getName(), PATHINFO_FILENAME);
            $safe = preg_replace('~[^a-z0-9-_]+~i', '-', $base) ?: 'file';
            $new  = $safe . '-' . date('YmdHis') . '.' . $ext;
            if (!$file->move($targetDir, $new)) {
                return redirect()->back()->with('error', 'Gagal mengunggah file');
            }
            // remove old file if exists
            $old = (string)($row['file'] ?? '');
            if ($old !== '') { $oldPath = FCPATH . ltrim($old, '/'); if (is_file($oldPath)) { @unlink($oldPath); } }
            $data['file'] = 'uploads/doc/' . $new;
        }
        try {
            $db->table('dokumentasi')->where('id', $id)->update($data);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', 'Gagal memperbarui dokumentasi');
        }
        return redirect()->to(site_url('admin/doc'))->with('success', 'Berhasil memperbarui dokumentasi');
    }
}
