<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class MasterRole extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $rows = [];
        try {
            // Role table typically has columns: id, role
            try {
                $rows = $db->table('role')->select('id, role as name')->orderBy('id','asc')->get()->getResultArray();
            } catch (\Throwable $e1) {
                // fallback variants
                try {
                    $rows = $db->table('role')->select('id, nama as name')->orderBy('id','asc')->get()->getResultArray();
                } catch (\Throwable $e2) {
                    $rows = $db->table('role')->select('id, name as name')->orderBy('id','asc')->get()->getResultArray();
                }
            }
        } catch (\Throwable $e) {
            $rows = [];
        }

        // attach actions HTML (icon-only)
        $rows = array_map(function($r){
            $id = (int)($r['id'] ?? 0);
            $actions = '<div class="inline-flex items-center justify-end gap-1">'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/role/show/'.$id).'" title="Detail" aria-label="Detail">'
                .'<i data-lucide="eye" class="w-4 h-4"></i>'
                .'</a>'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/role/edit/'.$id).'" title="Edit" aria-label="Edit">'
                .'<i data-lucide="pencil" class="w-4 h-4"></i>'
                .'</a>'
                .'<form method="post" action="'.base_url('admin/master/role/delete/'.$id).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'
                .csrf_field()
                .'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600">'
                .'<i data-lucide="trash-2" class="w-4 h-4"></i>'
                .'</button>'
                .'</form>'
                .'</div>';
            $r['actions'] = $actions;
            return $r;
        }, $rows);

        $data = [
            'title' => 'Master - Role',
            'rows'  => $rows,
        ];

        return view('Modules\\Admin\\Views\\master_role', $data);
    }

    private function detectNameColumn(): string
    {
        $db = db_connect();
        $fields = $db->getFieldNames('role');
        foreach (['role','nama','name'] as $c) {
            if (in_array($c, $fields, true)) return $c;
        }
        return 'role';
    }

    public function create()
    {
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_role_form', [
            'title' => 'Tambah Role',
            'action' => base_url('admin/master/role/store'),
            'method' => 'post',
            'value' => '',
            'submitLabel' => 'Simpan',
            'modal' => $isModal,
        ]);
    }

    public function store()
    {
        $name = trim((string)$this->request->getPost('name'));
        if ($name === '') {
            return redirect()->back()->with('error', 'Nama tidak boleh kosong');
        }
        $col = $this->detectNameColumn();
        $db = db_connect();
        $db->table('role')->insert([$col => $name]);
        return redirect()->to(base_url('admin/master/role'))->with('success', 'Role ditambahkan');
    }

    public function show(int $id)
    {
        $db = db_connect();
        $row = $db->table('role')->where('id', $id)->get()->getRowArray();
        if (!$row) {
            return redirect()->to(base_url('admin/master/role'))->with('error', 'Data tidak ditemukan');
        }
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_role_show', [
            'title' => 'Detail Role',
            'row' => $row,
            'modal' => $isModal,
        ]);
    }

    public function edit(int $id)
    {
        $db = db_connect();
        $row = $db->table('role')->where('id', $id)->get()->getRowArray();
        if (!$row) {
            return redirect()->to(base_url('admin/master/role'))->with('error', 'Data tidak ditemukan');
        }
        $name = $row['role'] ?? ($row['nama'] ?? ($row['name'] ?? ''));
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_role_form', [
            'title' => 'Edit Role',
            'action' => base_url('admin/master/role/update/'.$id),
            'method' => 'post',
            'value' => $name,
            'submitLabel' => 'Update',
            'modal' => $isModal,
        ]);
    }

    public function update(int $id)
    {
        $name = trim((string)$this->request->getPost('name'));
        if ($name === '') {
            return redirect()->back()->with('error', 'Nama tidak boleh kosong');
        }
        $col = $this->detectNameColumn();
        $db = db_connect();
        $db->table('role')->where('id', $id)->update([$col => $name]);
        return redirect()->to(base_url('admin/master/role'))->with('success', 'Role diperbarui');
    }

    public function delete(int $id)
    {
        $db = db_connect();
        $db->table('role')->where('id', $id)->delete();
        return redirect()->to(base_url('admin/master/role'))->with('success', 'Role dihapus');
    }
}
