<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;
use App\Models\CapaianOutputModel;

class Periode extends BaseController
{
    public function index()
    {
        helper(['laporan', 'url']);
        $rencana = (int)($this->request->getGet('rencana') ?? 0);
        $pelaksana = (int)($this->request->getGet('pelaksana') ?? 0);
        $indikator = (int)($this->request->getGet('indikator') ?? 0);
        $isDebug = ((string)($this->request->getGet('debug') ?? '') === '1');
        $rows = [];
        $years = [];
        $yearRows = [];
        // Build initial year rows: Pemda-only (level1.id = 6), approved statuses, group by k.tahun
        $map = [];
        try {
            $db = db_connect();
            $rowsPemda = $db->table('keberhasilan k')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                ->select('k.tahun as tahun', false)
                ->select('COUNT(*) as jumlah', false)
                ->groupStart()->where('k.status_eval', 2)->orWhere('k.status', '2')->groupEnd()
                ->where('l1.id', 6)
                ->where('k.tahun IS NOT NULL', null, false)
                ->where('k.tahun <> ""', null, false)
                ->groupBy('k.tahun')
                ->orderBy('tahun', 'DESC')
                ->get()->getResultArray();
            foreach ($rowsPemda as $r) {
                $ty = isset($r['tahun']) ? (int)$r['tahun'] : 0;
                if ($ty > 0) { $map[$ty] = (int)($r['jumlah'] ?? 0); }
            }
        } catch (\Throwable $e) { $map = []; }
        if ($isDebug) {
            try {
                $db = db_connect();
                $tables = $db->listTables();
                $counts = [];
                foreach (['keberhasilan','rencana','indikator','pelaksana','set_eval','level1','level2','level3'] as $t) {
                    try { $counts[$t] = (int) $db->table($t)->countAllResults(); } catch (\Throwable $e) { $counts[$t] = 'missing'; }
                }
                $samples = [];
                foreach (['keberhasilan','rencana','indikator','set_eval'] as $t) {
                    try { $samples[$t] = $db->table($t)->limit(3)->get()->getResultArray(); } catch (\Throwable $e) { $samples[$t] = []; }
                }
                return $this->response->setJSON([
                    'session' => [
                        'role_id' => (int)(session('role_id') ?? 0),
                        'role' => (string)(session('role') ?? ''),
                    ],
                    'rows_pemda' => $rowsPemda ?? [],
                    'tables' => $tables,
                    'table_counts' => $counts,
                    'samples' => $samples,
                ]);
            } catch (\Throwable $e) {
                return $this->response->setJSON([
                    'error' => $e->getMessage(),
                    'rows_pemda' => $rowsPemda ?? [],
                ]);
            }
        }
        if ($map) {
            krsort($map);
            foreach ($map as $y => $cnt) { $yearRows[] = [ 'tahun' => (int)$y, 'jumlah' => (int)$cnt ]; }
        } else {
            // fallback: show last 5 years with 0
            $y = (int) date('Y');
            for ($i=0; $i<5; $i++) { $yearRows[] = ['tahun' => $y-$i, 'jumlah' => 0]; }
        }
        // If filters provided, compute totals per period as before
        if ($rencana && $pelaksana && $indikator) {
            $model = new CapaianOutputModel();
            $perList = listPeriode();
            foreach ($perList as $p) {
                [$tahun, $bulan] = explode('_', $p) + [0=>0,1=>0];
                $tahun = (int)$tahun; $bulan = (int)$bulan;
                $data = $model->getCapaian($rencana, $tahun, $bulan, $pelaksana, $indikator);
                $merged = mergeCapaian($data);
                $total = 0;
                foreach ($merged as $m) { $total += (int)($m['total_output'] ?? 0); }
                $rows[] = [
                    'periode' => $p,
                    'tahun' => $tahun,
                    'bulan' => $bulan,
                    'total_output' => $total,
                ];
            }
        }

        return view('admin/laporan/periode', [
            'title' => 'Laporan - Periode',
            'rencanaSel' => $rencana,
            'pelaksanaSel' => $pelaksana,
            'indikatorSel' => $indikator,
            'rows' => $rows,
            'years' => $years,
            'yearRows' => $yearRows,
        ]);
    }

    // GET admin/periode/indikator?rencana=ID
    public function indikator()
    {
        $rencanaId = (int)($this->request->getGet('rencana') ?? 0);
        if (!$this->request->isAJAX()) {
            return $this->response->setStatusCode(400)->setBody('Bad Request');
        }
        $items = [];
        if ($rencanaId > 0) {
            try {
                $items = db_connect()->table('indikator')->select('id, indikator')->where('rencana_id', $rencanaId)->get()->getResultArray();
            } catch (\Throwable $e) {
                $items = [];
            }
        }
        return $this->response->setJSON(['items' => $items]);
    }
}
