<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class Program extends BaseController
{
    public function index()
    {
        $bidangId = (int)($this->request->getGet('id') ?? 0);
        $db = db_connect();
        $rows = [];
        try {
            $builder = $db->table('program')->select('id, kode, program as nama')->orderBy('kode','asc')->orderBy('id','asc');
            if ($bidangId > 0) { $builder->where('bidang_id', $bidangId); }
            $rows = $builder->get()->getResultArray();
        } catch (\Throwable $e) { $rows = []; }

        // normalize display and compose rows
        $no = 1;
        foreach ($rows as &$r) {
            $r['no'] = $no++;
            $r['kode'] = trim((string)($r['kode'] ?? '')) !== '' ? (string)$r['kode'] : '-';
            $r['nama'] = trim((string)($r['nama'] ?? '')) !== '' ? (string)$r['nama'] : '-';
            $id = (int)($r['id'] ?? 0);
            $r['actions'] = '<div class="inline-flex items-center justify-end gap-1">'
                .'<a class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/rencana?id='.$id).'" title="Details" aria-label="Details"><i data-lucide="search" class="w-4 h-4"></i></a>'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/program/edit/'.$id).'" title="Edit" aria-label="Edit"><i data-lucide="pencil" class="w-4 h-4"></i></a>'
                .'<form method="post" action="'.base_url('admin/program/delete/'.$id).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'
                .csrf_field()
                .'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600"><i data-lucide="trash-2" class="w-4 h-4"></i></button>'
                .'</form>'
                .'</div>';
        }
        unset($r);

        return view('Modules\\Admin\\Views\\program', [
            'title' => 'Program',
            'bidangId' => $bidangId,
            'rows' => $rows,
        ]);
    }

    public function edit(int $id)
    {
        $db = db_connect();
        $row = $db->table('program')->where('id', $id)->get()->getRowArray();
        if (!$row) {
            return redirect()->to(base_url('admin/program'))->with('error', 'Data tidak ditemukan');
        }
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\program_form', [
            'title' => 'Edit Program',
            'action' => base_url('admin/program/update/'.$id),
            'value' => [
                'kode' => (string)($row['kode'] ?? ''),
                'nama' => (string)($row['program'] ?? ''),
                'bidang_id' => (int)($row['bidang_id'] ?? 0),
            ],
            'submitLabel' => 'Update',
            'modal' => $isModal,
        ]);
    }

    public function update(int $id)
    {
        $name = trim((string)$this->request->getPost('name'));
        $kode = trim((string)$this->request->getPost('kode'));
        $bidangId = (int)($this->request->getPost('bidang_id') ?? 0);
        if ($name === '') {
            return redirect()->back()->with('error', 'Nama tidak boleh kosong');
        }
        $data = ['program' => $name];
        if ($kode !== '') { $data['kode'] = $kode; }
        try {
            db_connect()->table('program')->where('id', $id)->update($data);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', 'Gagal memperbarui data');
        }
        if ($bidangId <= 0) {
            // fallback: resolve bidang_id to preserve filter
            try {
                $r = db_connect()->table('program')->select('bidang_id')->where('id',$id)->get()->getRowArray();
                $bidangId = (int)($r['bidang_id'] ?? 0);
            } catch (\Throwable $e) {}
        }
        $redir = base_url('admin/program') . ($bidangId>0 ? ('?id='.$bidangId) : '');
        return redirect()->to($redir)->with('success', 'Program diperbarui');
    }

    public function delete(int $id)
    {
        $bidangId = 0;
        try {
            $r = db_connect()->table('program')->select('bidang_id')->where('id',$id)->get()->getRowArray();
            $bidangId = (int)($r['bidang_id'] ?? 0);
            db_connect()->table('program')->where('id', $id)->delete();
        } catch (\Throwable $e) {
            $redirErr = base_url('admin/program') . ($bidangId>0 ? ('?id='.$bidangId) : '');
            return redirect()->to($redirErr)->with('error', 'Gagal menghapus data');
        }
        $redir = base_url('admin/program') . ($bidangId>0 ? ('?id='.$bidangId) : '');
        return redirect()->to($redir)->with('success', 'Program dihapus');
    }
}
