<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\RedirectResponse;

class Setting extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $setting = $db->table('setting');
        $revisi  = $db->table('revisi');

        $t1 = $setting->where('id', 1)->get()->getRowArray();
        $t2 = $setting->where('id', 2)->get()->getRowArray();

        $t1r = $revisi->where('id', 1)->get()->getRowArray();
        $t2r = $revisi->where('id', 2)->get()->getRowArray();

        return view('admin/setting', [
            'title'     => 'Pengaturan Periode',
            't1'        => $t1,
            't2'        => $t2,
            't1_revisi' => $t1r,
            't2_revisi' => $t2r,
        ]);
    }

    public function update(): RedirectResponse
    {
        $this->validate(['tanggal1' => 'required']);
        $db = db_connect();
        $setting = $db->table('setting');

        $tanggal1 = (array) $this->request->getPost('tanggal1');
        foreach ($tanggal1 as $key => $val) {
            $data = [
                'bulan1' => $this->request->getPost('bulan1')[$key] ?? null,
                'tgl1'   => $this->request->getPost('tanggal1')[$key] ?? null,
                'tgl2'   => $this->request->getPost('tanggal2')[$key] ?? null,
                'bulan2' => $this->request->getPost('bulan2')[$key] ?? null,
                'tahun1' => $this->request->getPost('tahun1')[$key] ?? null,
                'tahun2' => $this->request->getPost('tahun2')[$key] ?? null,
                'bulan'  => ($key == 0) ? 6 : 12,
            ];
            $id = (int)$key + 1;
            $setting->where('id', $id)->update($data);
        }
        $check = $this->request->getPost('check');
        if ($check !== null) {
            $db->table('setting')->update(['is_active' => $check]);
        }
        return redirect()->to(base_url('admin/setting'))->with('success', 'Berhasil mengubah setting');
    }

    public function updateRevisi(): RedirectResponse
    {
        $this->validate(['tanggal1' => 'required']);
        $db = db_connect();
        $revisi = $db->table('revisi');

        $tanggal1 = (array) $this->request->getPost('tanggal1');
        foreach ($tanggal1 as $key => $val) {
            $data = [
                'bulan1' => $this->request->getPost('bulan1')[$key] ?? null,
                'tgl1'   => $this->request->getPost('tanggal1')[$key] ?? null,
                'tgl2'   => $this->request->getPost('tanggal2')[$key] ?? null,
                'bulan2' => $this->request->getPost('bulan2')[$key] ?? null,
                'bulan'  => ($key == 0) ? 6 : 12,
                'tahun1' => $this->request->getPost('tahun1')[$key] ?? null,
                'tahun2' => $this->request->getPost('tahun2')[$key] ?? null,
            ];
            $id = (int)$key + 1;
            $revisi->where('id', $id)->update($data);
        }
        return redirect()->to(base_url('admin/setting'))->with('success', 'Berhasil mengubah setting revisi');
    }
}
