<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Admin Dashboard',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin', 'Dashboard']
]) ?>

  <div class="mb-6">
    <h1 class="text-2xl font-bold">Hi, welcome back!</h1>
    <p class="text-slate-500">Your web analytics dashboard template.</p>
  </div>

  <?php if (($levelSuffix ?? '') === 'pusat' && !empty($level1 ?? [])): ?>
    <div class="mt-6 grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-4">
      <?php foreach ($level1 as $val): ?>
        <div class="bg-white rounded-2xl border border-slate-200 shadow-sm hover:shadow-md transition-all p-4">
          <div class="text-4xl font-extrabold text-slate-800 text-center leading-none">
            <?= esc($val['jumlah'] ?? 0) ?>
          </div>
          <div class="mt-2 text-[12px] tracking-wide text-slate-600 text-center overflow-hidden text-ellipsis whitespace-nowrap" title="<?= esc($val['level1'] ?? '-') ?>">
            <?= esc($val['level1'] ?? '-') ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

  <?php if (\App\Config\Custom::featureDashboardCapaian()): ?>
  <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 xl:grid-cols-6 gap-4">
    <?php foreach (($cards ?? []) as $c): ?>
      <?= view('components/kpi-badge', [
        'label' => $c['title'] ?? '-',
        'value' => $c['value'] ?? '-',
        'accent' => 'indigo',
      ]) ?>
    <?php endforeach; ?>
  </div>
  <?php endif; ?>

  <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mt-6">
    <div class="lg:col-span-2">
      <?php
        echo view('components/widget', [
          'title' => 'Website Audience Metrics',
          'subtitle' => 'Audience to which the users belonged within the current date range.',
          'actions' => [
            ['href' => '#', 'label' => 'Day'],
            ['href' => '#', 'label' => 'Week'],
            ['href' => '#', 'label' => 'Month'],
          ],
          'body' => '<canvas id="adminLine" height="120"></canvas>'
        ]);
      ?>
    </div>
    <div class="space-y-4">
      <?php
        echo view('components/widget', [
          'title' => 'Total Users',
          'subtitle' => 'Last 30 days',
          'body' => '<canvas id="adminBarSmall" height="100"></canvas>'
        ]);
      ?>
    </div>
  </div>

<?= view('layouts/dashboard_footer') ?>

<script>
  (function(){
    try {
      const l2 = <?php echo json_encode(array_values($topLevel2 ?? [])); ?>;
      const l3 = <?php echo json_encode(array_values($topLevel3 ?? [])); ?>;
      const l2Labels = l2.map(x => x.level2 || '-');
      const l2Data = l2.map(x => parseInt(x.jumlah || 0));
      const l3Labels = l3.map(x => x.level3 || '-');
      const l3Data = l3.map(x => parseInt(x.jumlah || 0));

      const lineCtx = document.getElementById('adminLine').getContext('2d');
      const pastel = ['#93c5fd','#a5b4fc','#c4b5fd','#fbcfe8','#fcd34d','#86efac','#a7f3d0','#bae6fd','#fca5a5','#fdba74'];
      new Chart(lineCtx, {
        type: 'bar',
        data: {
          labels: l3Labels,
          datasets: [{
            data: l3Data,
            backgroundColor: l3Data.map((_, i) => pastel[i % pastel.length]),
            borderColor: '#ffffff',
            borderWidth: 0,
            borderRadius: 6,
            maxBarThickness: 28
          }]
        },
        options: {
          plugins: { legend: { display: false } },
          scales: { y: { beginAtZero: true } }
        }
      });

      const smallBar = document.getElementById('adminBarSmall').getContext('2d');
      new Chart(smallBar, {
        type: 'pie',
        data: {
          labels: l2Labels.slice(0,12),
          datasets: [{
            data: l2Data.slice(0,12),
            backgroundColor: l2Labels.slice(0,12).map((_, i) => pastel[i % pastel.length]),
            borderColor: '#ffffff',
            borderWidth: 2
          }]
        },
        options: {
          plugins: { legend: { display: true, position: 'bottom' } }
        }
      });
    } catch(e) { /* noop */ }
  })();
</script>
