<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Management User',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Management User']
]) ?>

  <div class="mb-6 flex items-center justify-between">
    <div>
      <h1 class="text-2xl font-bold">Management User</h1>
      <p class="text-slate-500">Kelola akun pengguna</p>
    </div>
    <a data-modal href="<?= base_url('admin/user/create') ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50 text-sm">
      <i data-lucide="plus" class="w-4 h-4"></i>
      <span>Tambah</span>
    </a>
  </div>

  <section class="pb-6">
    <?php
      echo view('components/data-table', [
        'id' => 'dt_users',
        'headers' => [
          ['key' => 'no', 'label' => 'No'],
          ['key' => 'nama', 'label' => 'Nama'],
          ['key' => 'username', 'label' => 'Username'],
          ['key' => 'role', 'label' => 'Role'],
          ['key' => 'level', 'label' => 'Level', 'raw' => true],
          ['key' => 'group_wilayah', 'label' => 'Group Wilayah'],
          ['key' => 'wilayah', 'label' => 'Wilayah'],
          ['key' => 'actions', 'label' => 'Aksi', 'raw' => true],
        ],
        'rows' => array_values($rows ?? []),
        'pageSize' => 10,
      ]);
    ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
