<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Profil Admin',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Profil']
]) ?>

  <div class="mb-6">
    <h1 class="text-2xl font-bold">Profil</h1>
    <p class="text-slate-500">Perbarui informasi akun Anda</p>
  </div>

  <section class="pb-6">
    <?php if (session()->getFlashdata('success')): ?>
      <div class="mb-4 p-3 rounded bg-emerald-50 text-emerald-700 border border-emerald-200">
        <?= esc(session()->getFlashdata('success')) ?>
      </div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')): ?>
      <div class="mb-4 p-3 rounded bg-rose-50 text-rose-700 border border-rose-200">
        <?= esc(session()->getFlashdata('error')) ?>
      </div>
    <?php endif; ?>

    <div class="bg-white rounded-2xl shadow p-6">
      <form method="post" action="<?= base_url('admin/profile') ?>" class="grid grid-cols-1 gap-4">
        <?= csrf_field() ?>
        <div>
          <label class="block text-sm text-slate-600 mb-1">Nama</label>
          <input name="nama" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc($user['nama'] ?? '') ?>" required />
        </div>
        <div>
          <label class="block text-sm text-slate-600 mb-1">Username</label>
          <input name="username" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc($user['username'] ?? '') ?>" required />
        </div>
        <div>
          <label class="block text-sm text-slate-600 mb-1">No HP</label>
          <input name="no_hp" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc($user['no_hp'] ?? '') ?>" />
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="block text-sm text-slate-600 mb-1">Password Lama</label>
            <input name="password_lama" type="password" class="w-full border rounded-lg px-3 py-2" placeholder="Wajib untuk konfirmasi" />
          </div>
          <div>
            <label class="block text-sm text-slate-600 mb-1">Password Baru</label>
            <input name="password" type="password" class="w-full border rounded-lg px-3 py-2" placeholder="Opsional" />
          </div>
        </div>

        <div class="flex justify-end gap-2 mt-4">
          <a href="<?= base_url('admin') ?>" class="px-4 py-2 rounded-lg border">Batal</a>
          <button type="submit" class="px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">Simpan</button>
        </div>
      </form>
    </div>
  </section>
<?= view('layouts/dashboard_footer') ?>
