<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Dashboard Eksekutif',
  'active' => 'dashboard',
  'breadcrumb' => ['Eksekutif','Dashboard']
]) ?>

  <div class="mb-6">
    <h1 class="text-2xl font-bold">Dashboard Eksekutif</h1>
    <p class="text-slate-500">Ringkasan indikator dan laporan</p>
  </div>

  <main class="max-w-7xl mx-auto p-0 sm:p-0">
    <?= view('components/filter-bar', [
      'searchPlaceholder' => 'Cari indikator/KPI...',
      'actions' => [
        ['href' => base_url('upload'), 'label' => 'Upload Laporan'],
      ],
    ]) ?>

    <?php if (\App\Config\Custom::featureDashboardCapaian()): ?>
      <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <?= view('components/kpi-badge', ['label' => 'KPI', 'value' => '0', 'accent' => 'indigo']) ?>
        <?= view('components/kpi-badge', ['label' => 'Targets', 'value' => '0', 'accent' => 'emerald']) ?>
        <?= view('components/kpi-badge', ['label' => 'Laporan', 'value' => '0', 'accent' => 'sky']) ?>
      </div>
    <?php endif; ?>

    <div class="bg-white rounded-2xl shadow p-6 mt-6">
      <h2 class="text-lg font-semibold mb-3">Ringkasan</h2>
      <?= view('components/table', [
        'headers' => ['Topik','Status','Aksi'],
        'rows' => [
          ['Contoh 1','Aktif','-'],
          ['Contoh 2','Pending','-'],
        ],
      ]) ?>
    </div>
  </main>
<?= view('layouts/dashboard_footer') ?>
