<?php
namespace Modules\Evaluator\Controllers;

use App\Controllers\BaseController;

class Laporan extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $roleId = (int)(session('role_id') ?? 0);

        // Get years for laporan (status_eval = 1)
        try {
            $tahun = $db->table('keberhasilan k')
                ->select('k.tahun, COUNT(*) as jumlah')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.status_eval', 1)
                ->groupBy('k.tahun')
                ->orderBy('k.tahun', 'DESC')
                ->get()->getResultArray();
        } catch (\Throwable $e) { $tahun = []; }

        // Get years for history (status_eval not in 0,1)
        try {
            $tahun_history = $db->table('keberhasilan k')
                ->select('k.tahun, COUNT(*) as jumlah')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.status_eval IS NOT NULL', null, false)
                ->where('k.status_eval <>', 1)
                ->where('k.status_eval <>', 0)
                ->groupBy('k.tahun')
                ->orderBy('k.tahun', 'DESC')
                ->get()->getResultArray();
        } catch (\Throwable $e) { $tahun_history = []; }

        return view('Modules\\Evaluator\\Views\\laporan_index', [
            'title' => 'Laporan',
            'tahun' => $tahun,
            'tahun_history' => $tahun_history,
        ]);
    }

    public function rencana()
    {
        $db = db_connect();
        $roleId = (int)(session('role_id') ?? 0);
        $tahun = (int)($this->request->getGet('tahun') ?? 0);
        $status = (string)($this->request->getGet('status') ?? '');

        // Get rencana list with count
        try {
            $builder = $db->table('rencana r')
                ->select('r.id, r.kode, r.aksi, COUNT(k.id) as jumlah')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->join('indikator i', 'i.rencana_id = r.id', 'left')
                ->join('keberhasilan k', 'k.indikator_id = i.id AND k.tahun = ' . $tahun, 'left')
                ->where('se.role_id', $roleId);
            
            if ($status === 'true' || $status === '1') {
                $builder->where('k.status_eval IS NOT NULL', null, false)
                    ->where('k.status_eval <>', 1)
                    ->where('k.status_eval <>', 0);
            } else {
                $builder->where('k.status_eval', 1);
            }
            
            $rencana = $builder->groupBy('r.id')
                ->having('jumlah >', 0)
                ->orderBy('r.kode', 'ASC')
                ->get()->getResultArray();
        } catch (\Throwable $e) { $rencana = []; }

        return view('Modules\\Evaluator\\Views\\laporan_rencana', [
            'title' => 'Laporan',
            'rencana' => $rencana,
            'tahun' => $tahun,
            'status' => $status,
        ]);
    }

    public function detail()
    {
        $tahun = (int)($this->request->getGet('tahun') ?? 0);
        $rencanaId = (int)($this->request->getGet('rencana_id') ?? 0);
        $status = (string)($this->request->getGet('status') ?? '');

        $db = db_connect();
        try {
            $rencana = $db->table('rencana')->where('id', $rencanaId)->get()->getRowArray();
            $indikatorCount = $db->table('indikator')->where('rencana_id', $rencanaId)->countAllResults();
        } catch (\Throwable $e) { 
            $rencana = []; 
            $indikatorCount = 0;
        }

        // Generate laporan data for bulan 6 and 12
        $bulan6 = $this->generateLaporan($rencanaId, $tahun, 6);
        $bulan12 = $this->generateLaporan($rencanaId, $tahun, 12);
        
        $ringkasan6 = $this->ringkasanLaporan($rencanaId, $tahun, 6);
        $ringkasan12 = $this->ringkasanLaporan($rencanaId, $tahun, 12);

        return view('Modules\\Evaluator\\Views\\laporan_detail', [
            'title' => 'Detail Laporan',
            'rencana' => $rencana,
            'tahun' => $tahun,
            'rencanaId' => $rencanaId,
            'status' => $status,
            'bulan6' => $bulan6,
            'bulan12' => $bulan12,
            'ringkasan6' => $ringkasan6,
            'ringkasan12' => $ringkasan12,
            'indikator' => $indikatorCount,
        ]);
    }

    private function generateLaporan($rencanaId, $tahun, $bulan)
    {
        $db = db_connect();
        try {
            return $db->table('keberhasilan k')
                ->select('k.*, p.level1, p.level2, p.level3, i.indikator')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->where('i.rencana_id', $rencanaId)
                ->where('k.tahun', $tahun)
                ->where('k.bulan', $bulan)
                ->get()->getResultArray();
        } catch (\Throwable $e) { return []; }
    }

    private function ringkasanLaporan($rencanaId, $tahun, $bulan)
    {
        $db = db_connect();
        try {
            return $db->table('keberhasilan k')
                ->select('COUNT(*) as total, SUM(CASE WHEN k.status_eval = 2 THEN 1 ELSE 0 END) as approved, SUM(CASE WHEN k.status_eval = 3 THEN 1 ELSE 0 END) as rejected')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->where('i.rencana_id', $rencanaId)
                ->where('k.tahun', $tahun)
                ->where('k.bulan', $bulan)
                ->get()->getRowArray() ?? [];
        } catch (\Throwable $e) { return []; }
    }

    public function getAll()
    {
        $db = db_connect();
        $roleId = (int)(session('role_id') ?? 0);
        $tahun = (int)($this->request->getPost('tahun') ?? 0);
        $rencanaId = (int)($this->request->getPost('rencana_id') ?? 0);
        $status = (string)($this->request->getPost('status') ?? '');

        try {
            $builder = $db->table('keberhasilan k')
                ->select('k.id, k.tahun, k.bulan, k.keberhasilan, k.status_eval, k.catatan_eval, p.level1, p.level2, p.level3, i.indikator, r.aksi, r.kode')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.tahun', $tahun)
                ->where('r.id', $rencanaId);

            if ($status === 'true' || $status === '1') {
                $builder->where('k.status_eval IS NOT NULL', null, false)
                    ->where('k.status_eval <>', 1)
                    ->where('k.status_eval <>', 0);
            } else {
                $builder->where('k.status_eval', 1);
            }

            $data = $builder->orderBy('k.id', 'DESC')->get()->getResultArray();
        } catch (\Throwable $e) {
            $data = [];
        }

        return $this->response->setJSON(['data' => $data]);
    }

    public function changeStatus()
    {
        $db = db_connect();
        $id = (int)($this->request->getPost('id') ?? 0);
        $status = (int)($this->request->getPost('status') ?? 0);
        $catatan = (string)($this->request->getPost('catatan') ?? '');

        try {
            $check = $db->table('keberhasilan')->where('id', $id)->get()->getRowArray();
            
            $data = ['status_eval' => $status];
            
            // Handle catatan_eval
            if ($check && ($check['catatan_eval'] ?? '') !== '') {
                if ($catatan !== '') {
                    $db->table('catatan')->insert([
                        'keberhasilan_id' => $id,
                        'catatan_eval' => $catatan,
                    ]);
                }
            } else {
                if ($catatan !== '') {
                    $data['catatan_eval'] = $catatan;
                }
            }

            $db->table('keberhasilan')->where('id', $id)->update($data);
            return $this->response->setJSON(['status' => true]);
        } catch (\Throwable $e) {
            return $this->response->setJSON(['status' => false, 'error' => $e->getMessage()]);
        }
    }

    public function dataDukung()
    {
        $keberhasilanId = (int)($this->request->getGet('id') ?? 0);
        $db = db_connect();

        try {
            $dataDukung = $db->table('dukung d')
                ->select('d.*, s.satuan')
                ->join('satuan s', 's.id = d.satuan', 'left')
                ->where('d.keberhasilan_id', $keberhasilanId)
                ->get()->getRowArray() ?? [];

            // Get satuan list
            $satuanList = $db->table('keberhasilan k')
                ->select('s.satuan, is.satuan_id as id, is.level2_id')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('indikator_satuan is', 'is.indikator_id = i.id', 'left')
                ->join('satuan s', 's.id = is.satuan_id', 'left')
                ->where('k.id', $keberhasilanId)
                ->get()->getResultArray();

            $dataDukung['satuan_list'] = $satuanList;

            return $this->response->setJSON($dataDukung);
        } catch (\Throwable $e) {
            return $this->response->setJSON([]);
        }
    }

    public function deleteDukung()
    {
        $db = db_connect();
        $id = (int)($this->request->getGet('id') ?? 0);

        try {
            $db->table('dukung')->where('keberhasilan_id', $id)->delete();
            $db->table('keberhasilan')->where('id', $id)->update(['status_eval' => null]);
            return $this->response->setJSON(['status' => true]);
        } catch (\Throwable $e) {
            return $this->response->setJSON(['status' => false]);
        }
    }

    public function updateDukung()
    {
        $db = db_connect();
        $id = (int)($this->request->getPost('id') ?? 0);
        
        $data = [
            'keterangan_pelaksana' => (string)($this->request->getPost('keterangan_pelaksana') ?? ''),
            'jumlah_output' => (string)($this->request->getPost('jumlah_output') ?? ''),
            'hambatan_kendala' => (string)($this->request->getPost('hambatan_kendala') ?? ''),
            'pihak_yang_membantu' => (string)($this->request->getPost('pihak_yang_membantu') ?? ''),
            'rekomendasi_lanjut' => (string)($this->request->getPost('rekomendasi_lanjut') ?? ''),
            'penanggung_jawab' => (string)($this->request->getPost('penanggung_jawab') ?? ''),
            'jabatan' => (string)($this->request->getPost('jabatan') ?? ''),
            'link' => (string)($this->request->getPost('link_data_dukung') ?? ''),
        ];

        try {
            $update = $db->table('dukung')->where('keberhasilan_id', $id)->update($data);
            return $this->response->setJSON(['status' => $update]);
        } catch (\Throwable $e) {
            return $this->response->setJSON(['status' => false]);
        }
    }
}
