<?php
namespace Modules\Evaluator\Controllers;

use App\Controllers\BaseController;

class Permohonan extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $roleId = (int)(session('role_id') ?? 0);

        // Get years for permohonan (status = 1)
        try {
            $tahun = $db->table('keberhasilan k')
                ->select('k.tahun, COUNT(*) as jumlah')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.status', 1)
                ->groupBy('k.tahun')
                ->orderBy('k.tahun', 'DESC')
                ->get()->getResultArray();
        } catch (\Throwable $e) { $tahun = []; }

        // Get years for history (status not in 0,1)
        try {
            $tahun_history = $db->table('keberhasilan k')
                ->select('k.tahun, COUNT(*) as jumlah')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.status IS NOT NULL', null, false)
                ->where('k.status <>', 1)
                ->where('k.status <>', 0)
                ->groupBy('k.tahun')
                ->orderBy('k.tahun', 'DESC')
                ->get()->getResultArray();
        } catch (\Throwable $e) { $tahun_history = []; }

        return view('Modules\\Evaluator\\Views\\permohonan_index', [
            'title' => 'Permohonan',
            'tahun' => $tahun,
            'tahun_history' => $tahun_history,
        ]);
    }

    public function rencana()
    {
        $db = db_connect();
        $roleId = (int)(session('role_id') ?? 0);
        $tahun = (int)($this->request->getGet('tahun') ?? 0);
        $status = (string)($this->request->getGet('status') ?? '');

        // Get rencana list with count
        try {
            $builder = $db->table('rencana r')
                ->select('r.id, r.kode, r.aksi, COUNT(k.id) as jumlah')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->join('indikator i', 'i.rencana_id = r.id', 'left')
                ->join('keberhasilan k', 'k.indikator_id = i.id AND k.tahun = ' . $tahun, 'left')
                ->where('se.role_id', $roleId);
            
            if ($status === 'true' || $status === '1') {
                $builder->where('k.status IS NOT NULL', null, false)
                    ->where('k.status <>', 1)
                    ->where('k.status <>', 0);
            } else {
                $builder->where('k.status', 1);
            }
            
            $rencana = $builder->groupBy('r.id')
                ->having('jumlah >', 0)
                ->orderBy('r.kode', 'ASC')
                ->get()->getResultArray();
        } catch (\Throwable $e) { $rencana = []; }

        return view('Modules\\Evaluator\\Views\\permohonan_rencana', [
            'title' => 'Permohonan',
            'rencana' => $rencana,
            'tahun' => $tahun,
            'status' => $status,
        ]);
    }

    public function detail()
    {
        $tahun = (int)($this->request->getGet('tahun') ?? 0);
        $rencanaId = (int)($this->request->getGet('rencana_id') ?? 0);
        $status = (string)($this->request->getGet('status') ?? '');

        $db = db_connect();
        try {
            $rencana = $db->table('rencana')->where('id', $rencanaId)->get()->getRowArray();
        } catch (\Throwable $e) { $rencana = []; }

        return view('Modules\\Evaluator\\Views\\permohonan_detail', [
            'title' => 'Detail Permohonan',
            'rencana' => $rencana,
            'tahun' => $tahun,
            'rencanaId' => $rencanaId,
            'status' => $status,
        ]);
    }

    public function getAll()
    {
        $db = db_connect();
        $roleId = (int)(session('role_id') ?? 0);
        $tahun = (int)($this->request->getPost('tahun') ?? 0);
        $rencanaId = (int)($this->request->getPost('rencana_id') ?? 0);
        $status = (string)($this->request->getPost('status') ?? '');

        try {
            $builder = $db->table('keberhasilan k')
                ->select('k.id, k.tahun, k.bulan, k.keberhasilan, k.status, k.catatan, p.level1, p.level2, p.level3, i.indikator, r.aksi, r.kode')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->where('se.role_id', $roleId)
                ->where('k.tahun', $tahun)
                ->where('r.id', $rencanaId);

            if ($status === 'true' || $status === '1') {
                $builder->where('k.status IS NOT NULL', null, false)
                    ->where('k.status <>', 1)
                    ->where('k.status <>', 0);
            } else {
                $builder->where('k.status', 1);
            }

            $data = $builder->orderBy('k.id', 'DESC')->get()->getResultArray();
        } catch (\Throwable $e) {
            $data = [];
        }

        return $this->response->setJSON(['data' => $data]);
    }

    public function changeStatus()
    {
        $db = db_connect();
        $id = (int)($this->request->getPost('id') ?? 0);
        $status = (int)($this->request->getPost('status') ?? 0);
        $catatan = (string)($this->request->getPost('catatan') ?? '');

        try {
            // Get existing record
            $check = $db->table('keberhasilan')->where('id', $id)->get()->getRowArray();
            
            $data = ['status' => $status];
            
            // Handle catatan
            if ($check && ($check['catatan'] ?? '') !== '') {
                if ($catatan !== '') {
                    $db->table('catatan')->insert([
                        'keberhasilan_id' => $id,
                        'catatan' => $catatan,
                    ]);
                }
            } else {
                if ($catatan !== '') {
                    $data['catatan'] = $catatan;
                }
            }

            $db->table('keberhasilan')->where('id', $id)->update($data);
            return $this->response->setJSON(['status' => true]);
        } catch (\Throwable $e) {
            return $this->response->setJSON(['status' => false, 'error' => $e->getMessage()]);
        }
    }

    public function deletePkran()
    {
        $db = db_connect();
        $id = (int)($this->request->getGet('id') ?? 0);

        try {
            $db->table('keberhasilan')->where('id', $id)->delete();
            return $this->response->setJSON(['status' => true]);
        } catch (\Throwable $e) {
            return $this->response->setJSON(['status' => false]);
        }
    }

    public function updatePkran()
    {
        $db = db_connect();
        $id = (int)($this->request->getPost('id') ?? 0);
        $pkran = (string)($this->request->getPost('pkran') ?? '');

        try {
            $db->table('keberhasilan')->where('id', $id)->update(['keberhasilan' => $pkran]);
            return $this->response->setJSON(['status' => true]);
        } catch (\Throwable $e) {
            return $this->response->setJSON(['status' => false]);
        }
    }
}
