<?php
namespace Modules\User\Controllers;

use App\Controllers\BaseController;
use App\Models\UserLevelModel;
use App\Models\PemantauanModel;

class Dashboard extends BaseController
{
    public function index()
    {
        $session = session();
        // session keys set at login: 'level1','level2','level3' hold IDs
        $level1Id = (int) ($session->get('level1') ?? 0);
        $level2Id = (int) ($session->get('level2') ?? 0);
        $level3Id = (int) ($session->get('level3') ?? 0);
        $levelModel = new UserLevelModel();
        $levels = $levelModel->getLevelNames($level1Id ?: null, $level2Id ?: null, $level3Id ?: null);
        // Detect source table & columns
        $source = null; $fields = [];
        try {
            $dbProbe = db_connect();
            foreach (['dokumentasi','dokumen','laporan'] as $tbl) {
                try { $f = $dbProbe->getFieldNames($tbl); $source = $tbl; $fields = $f; break; } catch (\Throwable $e) { /* try next */ }
            }
        } catch (\Throwable $e) { /* ignore */ }

        // Load recent activities filtered by levels if columns are available
        $activities = [];
        try {
            if (!$source) throw new \RuntimeException('No source table');
            $db = db_connect();
            $builder = $db->table($source);
            if (in_array('level', $fields, true)) {
                $builder->where('level', 3);
            }
            if ($level1Id && in_array('level1_id', $fields, true)) {
                $builder->where('level1_id', $level1Id);
            }
            if ($level2Id && in_array('level2_id', $fields, true)) {
                $builder->where('level2_id', $level2Id);
            }
            if ($level3Id && in_array('level3_id', $fields, true)) {
                $builder->where('level3_id', $level3Id);
            }
            // Order by most recent id/created_at when available
            if (in_array('created_at', $fields, true)) {
                $builder->orderBy('created_at', 'DESC');
            } elseif (in_array('tanggal', $fields, true)) {
                $builder->orderBy('tanggal', 'DESC');
            } else {
                $builder->orderBy('id', 'DESC');
            }
            $builder->limit(10);
            $rows = $builder->get()->getResultArray();
            foreach ($rows as $r) {
                $dateVal = $r['created_at'] ?? ($r['tanggal'] ?? null);
                if ($dateVal) {
                    $dateDisp = is_numeric($dateVal) ? date('Y-m-d', (int) $dateVal) : date('Y-m-d', strtotime((string) $dateVal));
                } else {
                    $dateDisp = date('Y-m-d');
                }
                $name = $r['judul'] ?? ($r['nama_file'] ?? ($r['nama'] ?? ('Dokumen #' . ($r['id'] ?? ''))));
                $status = $r['status'] ?? ($r['state'] ?? '-');
                $activities[] = [$dateDisp, (string) $name, (string) $status];
            }
        } catch (\Throwable $e) {
            $activities = [];
        }
        // Simple KPI and card derivation
        $laporanCount = count($activities);
        $waiting = 0; $approved = 0;
        try {
            if ($source) {
                $db2 = db_connect();
                $fields2 = $fields;
                $b2 = $db2->table($source);
                if (in_array('level', $fields2, true)) $b2->where('level', 3);
                if ($level1Id && in_array('level1_id', $fields2, true)) $b2->where('level1_id', $level1Id);
                if ($level2Id && in_array('level2_id', $fields2, true)) $b2->where('level2_id', $level2Id);
                if ($level3Id && in_array('level3_id', $fields2, true)) $b2->where('level3_id', $level3Id);
                $statusCol = in_array('status', $fields2, true) ? 'status' : (in_array('state', $fields2, true) ? 'state' : null);
                if ($statusCol) {
                    $b2->select("$statusCol as s, COUNT(*) as cnt")->groupBy('s');
                } else {
                    $b2->select('COUNT(*) as cnt');
                }
                foreach ($b2->get()->getResultArray() as $row) {
                    $st = strtolower((string)($row['s'] ?? ''));
                    $cnt = (int) ($row['cnt'] ?? 0);
                    if ($st) {
                        if (in_array($st, ['approved','disetujui','selesai'], true)) $approved += $cnt;
                        if (in_array($st, ['pending','menunggu','proses'], true)) $waiting += $cnt;
                    } else {
                        // if no status column, treat as approved=cnt
                        $approved += $cnt;
                    }
                }
            }
        } catch (\Throwable $e) {
            // ignore, keep defaults
        }
        $kpi = [ 'progress' => '0%', 'laporan' => $laporanCount, 'notif' => $waiting ];

        // Load Bidang and counts using DB + PemantauanModel (old_app style cards)
        $db = db_connect();
        try {
            $bidangList = $db->table('bidang')->select('id,bidang,warna,kode_warna')->get()->getResultArray();
        } catch (\Throwable $e) { $bidangList = []; }
        $bidangCards = [];
        // Count rencana/pelaksana per bidang based on current scope
        $pm = new PemantauanModel();
        $rencanaScope = $pm->getRencana($level1Id ?: null, $level2Id ?: null, $level3Id ?: null);
        $counts = [];
        foreach ($rencanaScope as $row) {
            $bid = (int)($row['bidang_id'] ?? 0);
            $counts[$bid] = ($counts[$bid] ?? 0) + 1;
        }
        foreach ($bidangList as &$b) {
            $b['jumlah'] = (int)($counts[(int)($b['id'] ?? 0)] ?? 0);
        }
        unset($b);

        // Build series data for Highcharts like old_app: per bidang per tahun
        $years = [];
        try { $maxIdx = (int) (function_exists('year') ? year() : 4); } catch (\Throwable $e) { $maxIdx = 4; }
        for ($i=0; $i <= $maxIdx; $i++) { $years[] = '202'.$i; }
        $seriesData = [];
        foreach ($bidangList as $b) {
            $bid = (int)($b['id'] ?? 0);
            $color = (string)($b['kode_warna'] ?? ($b['warna'] ?? '#6366f1'));
            $dataPts = [];
            foreach ($years as $yr) {
                // count keberhasilan rows in that year for this bidang and user scope
                try {
                    $qb = db_connect()->table('keberhasilan k')
                        ->select('COUNT(k.id) as c')
                        ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                        ->join('rencana r', 'r.id = p.rencana_id', 'left')
                        ->join('program pr', 'pr.id = r.program_id', 'left')
                        ->join('bidang bd', 'bd.id = pr.bidang_id', 'left')
                        ->where('bd.id', $bid)
                        ->where('k.tahun', (int)$yr);
                    if ($level1Id) $qb->where('p.level1_id', $level1Id);
                    if ($level2Id) $qb->where('p.level2_id', $level2Id);
                    if ($level3Id) $qb->where('p.level3_id', $level3Id);
                    $rowc = $qb->get()->getRowArray();
                    $dataPts[] = (int)($rowc['c'] ?? 0);
                } catch (\Throwable $e) {
                    $dataPts[] = 0;
                }
            }
            $seriesData[] = [ 'name' => (string)($b['bidang'] ?? 'Bidang'), 'data' => $dataPts, 'color' => $color ];
        }

        // Limit to 4 cards as per old_app layout
        $bidangList = array_slice($bidangList, 0, 4);

        return view('Modules\\User\\Views\\dashboard', [
            'title' => 'Dashboard',
            'bidang' => $bidangList,
            'seriesData' => $seriesData,
        ]);
    }
}
