<?php
namespace Modules\User\Controllers;

use App\Controllers\BaseController;

class Dokumentasi extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $docs = [];
        try {
            $docs = $db->table('dokumentasi')
                ->where('level', 1)
                ->orderBy('id', 'ASC')
                ->get()
                ->getResultArray();
        } catch (\Throwable $e) {
            $docs = [];
        }

        // Log history like old app
        try {
            $userId = (int) (session('id') ?? 0);
            foreach ($docs as $d) {
                $db->table('history_dokumentasi')->insert([
                    'dokumentasi_id' => (int) ($d['id'] ?? 0),
                    'user_id' => $userId,
                ]);
            }
        } catch (\Throwable $e) {
            // ignore logging errors
        }

        $data = [
            'title' => 'Dokumentasi',
            'doc' => $docs,
        ];

        return view('Modules\\User\\Views\\dokumentasi', $data);
    }
}
