<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'PK RAN',
  'active' => 'pemantauanran',
  'breadcrumb' => ['User','PK RAN']
]) ?>

<div class="bg-white rounded-2xl shadow p-6">
  <h4 class="text-lg font-semibold">Perjanjian Kinerja RAN P4GN</h4>
  <p class="text-sm text-slate-500">Untuk mengisi perjanjian kinerja di input tiap setahun sekali secara berkala</p>

  <div class="mt-4">
    <style>
      .pk-table{border-collapse:collapse}
      .pk-table td,.pk-table th{vertical-align:top;text-align:left;padding:.5rem .75rem;border:1px solid #e5e7eb}
    </style>
    <ul class="flex gap-2 border-b" role="tablist">
      <?php for ($i = 0; $i <= year(); $i++) : ?>
        <?php $yearStr = '202' . $i; $active = ($yearStr === date('Y')); ?>
        <li>
          <a href="#home<?= $yearStr; ?>" data-tab role="tab" class="inline-block px-4 py-2 border-b-2 <?= $active?'border-indigo-600 text-indigo-600':'border-transparent text-slate-600' ?>">
            <span><?= $yearStr; ?></span>
          </a>
        </li>
      <?php endfor; ?>
    </ul>
    <div class="tab-content">
      <?php for ($y = 0; $y <= year(); $y++) : ?>
        <?php $yearStr = '202' . $y; $active = ($yearStr === date('Y')); ?>
        <div id="home<?= $yearStr; ?>" role="tabpanel" class="mt-4 <?= $active?'':'hidden' ?>">
          <div class="overflow-x-auto">
            <table class="min-w-full table-auto border rounded pk-table">
              <thead class="bg-slate-50 text-xs">
                <tr>
                  <th class="px-3 py-2 text-left" width="350">Rencana Aksi</th>
                  <th class="px-3 py-2 text-left" width="200">Indikator Keberhasilan</th>
                  <th class="px-3 py-2 text-left" width="200">Ukuran Keberhasilan</th>
                  <th class="px-3 py-2 text-left"></th>
                  <th class="px-3 py-2 text-left">Ukuran Keberhasilan Spesifik (Tahun & Periode)</th>
                  <th class="px-3 py-2 text-left">Status</th>
                  <th class="px-3 py-2 text-left">Catatan Evaluator</th>
                </tr>
              </thead>
              <tbody class="text-sm">
                <?php $arr_az = range('A', 'Z'); ?>
                <?php foreach (($perjanjian ?? []) as $o => $pj) : ?>
                  <tr>
                    <th class="px-2 py-1" colspan="7"><?= $arr_az[$o] ?? ($o+1); ?> . <?= esc($pj['bidang'] ?? '-') ?></th>
                  </tr>
                  <?php foreach (($pj['program'] ?? []) as $a => $pg) : ?>
                    <tr>
                      <th class="px-2 py-1" colspan="7"><?= ($a + 1) . ' . ' . esc($pg['program'] ?? '-') ?></th>
                    </tr>
                    <?php foreach (($pg['rencana'] ?? []) as $ii => $rnc) : ?>
                      <tr>
                        <td rowspan="<?= (count($rnc['indikator'] ?? []) == 1) ? 2 : 4; ?>">
                          <div class="flex"><div class="pr-2"><?= ($ii + 1) . '.' ?></div><div><?= esc($rnc['aksi'] ?? '-') ?></div></div>
                        </td>
                        <?php $ind0 = $rnc['indikator'][0] ?? null; ?>
                        <td rowspan="2"><?= esc((string)($ind0['indikator'] ?? '-')) ?></td>
                        <td rowspan="2"><?= esc(spesifikIndikator($y, (int)($ind0['id'] ?? 0))) ?></td>
                        <td>B6</td>
                        <?php $keberhasilan = getKeberhasilanSpesifik($y, '6', (int)($ind0['id'] ?? 0), (int)($rnc['pelaksana_id'] ?? 0));
                          $result = empty($keberhasilan) || empty($keberhasilan['keberhasilan']) ? 'Klik di sini untuk mengisi perjanjian' : $keberhasilan['keberhasilan'];
                        ?>
                        <td class="text-indigo-600 uks px-2 py-1" contenteditable
                            data-id="<?= (int)($ind0['id'] ?? 0); ?>"
                            data-year="<?= $yearStr ?>"
                            data-month="6"
                            data-kid="<?= esc($keberhasilan['id'] ?? '') ?>"
                            data-status="<?= esc($keberhasilan['status'] ?? '') ?>"
                            data-pelaksana="<?= (int)($rnc['pelaksana_id'] ?? 0); ?>"
                            ><?= esc($result) ?></td>
                        <td><?= status($keberhasilan['status'] ?? null, $keberhasilan['catatan'] ?? null); ?></td>
                        <td>
                          <ul class="list-disc pl-5">
                            <?= (isset($keberhasilan['catatan'])) ? '<li>'.esc($keberhasilan['catatan']).'</li>' : '' ?>
                            <?php if (isset($keberhasilan['note'])) : foreach ($keberhasilan['note'] as $ctn) : ?>
                              <li class="mt-1"><?= esc($ctn['catatan'] ?? '') ?></li>
                            <?php endforeach; endif; ?>
                          </ul>
                        </td>
                      </tr>
                      <tr>
                        <td>B12</td>
                        <?php $keberhasilan = getKeberhasilanSpesifik($y, '12', (int)($ind0['id'] ?? 0), (int)($rnc['pelaksana_id'] ?? 0));
                          $result = empty($keberhasilan) || empty($keberhasilan['keberhasilan']) ? 'Klik di sini untuk mengisi perjanjian' : $keberhasilan['keberhasilan'];
                        ?>
                        <td class="text-indigo-600 uks px-2 py-1" contenteditable
                            data-id="<?= (int)($ind0['id'] ?? 0); ?>"
                            data-year="<?= $yearStr ?>"
                            data-month="12"
                            data-kid="<?= esc($keberhasilan['id'] ?? '') ?>"
                            data-status="<?= esc($keberhasilan['status'] ?? '') ?>"
                            data-pelaksana="<?= (int)($rnc['pelaksana_id'] ?? 0); ?>"
                            ><?= esc($result) ?></td>
                        <td><?= status($keberhasilan['status'] ?? null, $keberhasilan['catatan'] ?? null); ?></td>
                        <td>
                          <ul class="list-disc pl-5">
                            <?= (isset($keberhasilan['catatan'])) ? '<li>'.esc($keberhasilan['catatan']).'</li>' : '' ?>
                            <?php if (isset($keberhasilan['note'])) : foreach ($keberhasilan['note'] as $ctn) : ?>
                              <li class="mt-1"><?= esc($ctn['catatan'] ?? '') ?></li>
                            <?php endforeach; endif; ?>
                          </ul>
                        </td>
                      </tr>
                      <?php $inds = $rnc['indikator'] ?? []; for ($f = 1; $f < count($inds); $f++) { $ind = $inds[$f]; ?>
                        <tr>
                          <td rowspan="2"><?= esc((string)($ind['indikator'] ?? '-')) ?></td>
                          <td rowspan="2"><?= esc(spesifikIndikator($y, (int)($ind['id'] ?? 0))) ?></td>
                          <td>B6</td>
                          <?php $keberhasilan = getKeberhasilanSpesifik($y, '6', (int)($ind['id'] ?? 0), (int)($rnc['pelaksana_id'] ?? 0));
                            $result = empty($keberhasilan) || empty($keberhasilan['keberhasilan']) ? 'Klik di sini untuk mengisi perjanjian' : $keberhasilan['keberhasilan'];
                          ?>
                          <td class="text-indigo-600 <?= (kondisiPkran(6, $y, $keberhasilan['status'] ?? null)) ? 'uks' : '' ?> px-2 py-1" contenteditable
                              data-id="<?= (int)($ind['id'] ?? 0); ?>"
                              data-year="<?= $yearStr ?>"
                              data-month="6"
                              data-kid="<?= esc($keberhasilan['id'] ?? '') ?>"
                              data-status="<?= esc($keberhasilan['status'] ?? '') ?>"
                              data-pelaksana="<?= (int)($rnc['pelaksana_id'] ?? 0); ?>"
                              ><?= esc($result) ?></td>
                          <td><?= status($keberhasilan['status'] ?? null, $keberhasilan['catatan'] ?? null); ?></td>
                          <td>
                            <ul class="list-disc pl-5">
                              <?= (isset($keberhasilan['catatan'])) ? '<li>'.esc($keberhasilan['catatan']).'</li>' : '' ?>
                              <?php if (isset($keberhasilan['note'])) : foreach ($keberhasilan['note'] as $ctn) : ?>
                                <li class="mt-1"><?= esc($ctn['catatan'] ?? '') ?></li>
                              <?php endforeach; endif; ?>
                            </ul>
                          </td>
                        </tr>
                        <tr>
                          <td>B12</td>
                          <?php $keberhasilan = getKeberhasilanSpesifik($y, '12', (int)($ind['id'] ?? 0), (int)($rnc['pelaksana_id'] ?? 0));
                            $result = empty($keberhasilan) || empty($keberhasilan['keberhasilan']) ? 'Klik di sini untuk mengisi perjanjian' : $keberhasilan['keberhasilan'];
                          ?>
                          <td class="text-indigo-600 <?= (kondisiPkran(12, $y, $keberhasilan['status'] ?? null)) ? 'uks' : '' ?> px-2 py-1" contenteditable
                              data-id="<?= (int)($ind['id'] ?? 0); ?>"
                              data-year="<?= $yearStr ?>"
                              data-month="12"
                              data-kid="<?= esc($keberhasilan['id'] ?? '') ?>"
                              data-status="<?= esc($keberhasilan['status'] ?? '') ?>"
                              data-pelaksana="<?= (int)($rnc['pelaksana_id'] ?? 0); ?>"
                              ><?= esc($result) ?></td>
                          <td><?= status($keberhasilan['status'] ?? null, $keberhasilan['catatan'] ?? null); ?></td>
                          <td>
                            <ul class="list-disc pl-5">
                              <?= (isset($keberhasilan['catatan'])) ? '<li>'.esc($keberhasilan['catatan']).'</li>' : '' ?>
                              <?php if (isset($keberhasilan['note'])) : foreach ($keberhasilan['note'] as $ctn) : ?>
                                <li class="mt-1"><?= esc($ctn['catatan'] ?? '') ?></li>
                              <?php endforeach; endif; ?>
                            </ul>
                          </td>
                        </tr>
                      <?php } ?>
                    <?php endforeach; ?>
                  <?php endforeach; ?>
                <?php endforeach; ?>
              </tbody>
            </table>
            <?php if (!empty($perjanjian)) : ?>
              <button id="btn-send" class="mt-4 inline-flex items-center gap-2 px-3 py-2 rounded bg-indigo-600 text-white">Simpan Perubahan</button>
            <?php endif ?>
          </div>
        </div>
      <?php endfor; ?>
    </div>
  </div>
</div>

<!-- Modal Konfirmasi -->
<div id="confirmModal" class="fixed inset-0 z-50 hidden">
  <div class="absolute inset-0 bg-black/40"></div>
  <div class="relative mx-auto mt-40 w-full max-w-md bg-white rounded-xl shadow-lg">
    <div class="p-5 border-b">
      <h3 class="text-base font-semibold">Konfirmasi</h3>
    </div>
    <div class="p-5">
      <p>Apakah Yakin ingin mengirim perubahan?</p>
    </div>
    <div class="p-4 border-t flex justify-end gap-2">
      <button type="button" id="confirmCancel" class="px-3 py-2 rounded border bg-white hover:bg-slate-50">Batal</button>
      <button type="button" id="confirmOk" class="px-3 py-2 rounded bg-indigo-600 text-white hover:bg-indigo-700">Kirim</button>
    </div>
  </div>

<script>
(function(){
  // Tab persistence
  document.querySelectorAll('[data-tab]').forEach(function(a){
    a.addEventListener('click', function(ev){
      ev.preventDefault();
      var href = this.getAttribute('href');
      if (!href) return;
      localStorage.setItem('activeTabPkran', href);
      document.querySelectorAll('[role="tabpanel"]').forEach(function(p){ p.classList.add('hidden'); });
      var el = document.querySelector(href); if (el) el.classList.remove('hidden');
      document.querySelectorAll('[data-tab]').forEach(function(x){ x.classList.remove('border-indigo-600','text-indigo-600'); x.classList.add('border-transparent','text-slate-600'); });
      this.classList.add('border-indigo-600','text-indigo-600'); this.classList.remove('border-transparent','text-slate-600');
    });
  });
  var saved = localStorage.getItem('activeTabPkran');
  if (saved) {
    var link = document.querySelector('[data-tab][href="'+saved+'"]');
    if (link) link.click();
  }

  // Editable handling
  function isEditableCell(td){
    if (!td.classList.contains('uks')) return false;
    var st = td.getAttribute('data-status');
    return !(st === '1' || st === '2');
  }
  document.querySelectorAll('td.uks').forEach(function(td){
    if (!isEditableCell(td)) { td.setAttribute('contenteditable','false'); return; }
    td.addEventListener('blur', function(){
      var val = (td.textContent||'').trim();
      if (!val || val === '-' || val.toLowerCase().indexOf('klik di sini') === 0) { alert('Mohon di isi dengan benar'); return; }
      var body = new URLSearchParams();
      body.append('val', val);
      body.append('year', td.getAttribute('data-year'));
      body.append('indikator_id', td.getAttribute('data-id'));
      body.append('month', td.getAttribute('data-month'));
      body.append('pelaksana', td.getAttribute('data-pelaksana'));
      var kid = td.getAttribute('data-kid'); if (kid) body.append('id', kid);
      fetch('<?= site_url('user/pkran/addpkran') ?>', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: body.toString() })
        .then(r=>r.json()).then(function(js){ if (js && js.id) { td.setAttribute('data-kid', js.id); location.reload(); } });
    });
  });

  // Modal confirm logic
  var btn = document.getElementById('btn-send');
  var modal = document.getElementById('confirmModal');
  var btnOk = document.getElementById('confirmOk');
  var btnCancel = document.getElementById('confirmCancel');
  var backdrop = modal ? modal.querySelector('.absolute.inset-0') : null;
  var submitting = false;
  function openModal(){ if (modal) modal.classList.remove('hidden'); }
  function closeModal(){ if (modal) modal.classList.add('hidden'); submitting = false; }
  if (btn) btn.addEventListener('click', function(e){ e.preventDefault(); openModal(); });
  if (btnCancel) btnCancel.addEventListener('click', function(){ closeModal(); });
  if (backdrop) backdrop.addEventListener('click', function(){ closeModal(); });
  if (modal) modal.addEventListener('keydown', function(ev){ if (ev.key === 'Enter') { ev.preventDefault(); } });
  if (btnOk) btnOk.addEventListener('click', function(){
    if (submitting) return; submitting = true;
    fetch('<?= site_url('user/pkran/setstatus') ?>')
      .then(function(){ closeModal(); location.reload(); })
      .catch(function(){ submitting = false; });
  });
})();
</script>

<?= view('layouts/dashboard_footer') ?>
