<?= view('layouts/dashboard_header', [
  'title' => 'Dokumentasi',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Dokumentasi']
]) ?>

  <?php if (session()->getFlashdata('success')): ?>
    <div class="mb-4 p-3 rounded bg-emerald-50 text-emerald-700 border border-emerald-200">
      <?= esc(session()->getFlashdata('success')) ?>
    </div>
  <?php endif; ?>
  <?php if (session()->getFlashdata('error')): ?>
    <div class="mb-4 p-3 rounded bg-rose-50 text-rose-700 border border-rose-200">
      <?= esc(session()->getFlashdata('error')) ?>
    </div>
  <?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
      <div>
        <h2 class="text-lg font-semibold">Kelola Dokumentasi</h2>
        <p class="text-sm text-slate-500">Tambah panduan/file untuk pengguna</p>
      </div>
      <div>
        <a href="<?= site_url('admin/doc/form') ?>" data-modal class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50 text-sm">
          <i data-lucide="plus" class="w-4 h-4"></i>
          <span>Tambah</span>
        </a>
      </div>
    </div>

    <div class="mt-6">
      <?php
        $list = $rows ?? [];
        $headers = [
          ['key' => 'no', 'label' => 'No', 'noSort' => true],
          ['key' => 'desc', 'label' => 'Deskripsi'],
          ['key' => 'file', 'label' => 'File', 'raw' => true],
          ['key' => 'level', 'label' => 'Penerima'],
          ['key' => 'actions', 'label' => 'Aksi', 'raw' => true, 'align' => 'right'],
        ];
        $mapLevel = [1=>'Semua',2=>'Evaluator',3=>'Eksekutif',4=>'User'];
        $tableRows = array_map(function($r) use($mapLevel){
          $desc = (string)($r['desc'] ?? '');
          $f = trim((string)($r['file'] ?? ''));
          $fileHtml = $f !== '' ? ('<a class="text-indigo-600 hover:text-indigo-700" href="'.base_url($f).'" target="_blank" rel="noopener">File</a>') : '<span class="text-slate-400">-</span>';
          $lvl = (int)($r['level'] ?? 1);
          $levelLabel = $mapLevel[$lvl] ?? 'Semua';
          $id = (int)($r['id'] ?? 0);
          $editBtn = '<a href="'.site_url('admin/doc/edit/'.$id).'" data-modal title="Edit" aria-label="Edit" class="inline-flex items-center justify-center w-8 h-8 rounded border text-sky-600 border-sky-200 hover:bg-sky-50 mr-1">'
            .'<i data-lucide="pencil" class="w-4 h-4"></i>'
            .'</a>';
          $delBtn = '<form method="post" action="'.site_url('admin/doc/delete/'.$id).'" data-confirm="Hapus item dokumentasi ini?" style="display:inline-block">'
            .csrf_field()
            .'<button type="submit" title="Hapus" aria-label="Hapus" class="inline-flex items-center justify-center w-8 h-8 rounded border text-rose-600 border-rose-200 hover:bg-rose-50">'
            .'<i data-lucide="trash-2" class="w-4 h-4"></i>'
            .'</button></form>';
          $actions = $editBtn.$delBtn;
          return [ 'desc'=>$desc, 'file'=>$fileHtml, 'level'=>$levelLabel, 'actions'=>$actions ];
        }, $list);
        echo view('components/data-table', [
          'id' => 'dt_doc',
          'headers' => $headers,
          'rows' => $tableRows,
          'pageSize' => 10,
        ]);
      ?>
    </div>
  </div>

<?= view('layouts/dashboard_footer') ?>
