<?= view('layouts/dashboard_header', [
  'title' => 'Laporan - Capaian Output',
  'active' => 'laporan',
  'breadcrumb' => ['Admin','Laporan','Capaian Output']
]) ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <h2 class="text-lg font-semibold">Capaian Output</h2>
    <p class="text-sm text-slate-500">Anda dapat memilih laporan berdasarkan field di bawah</p>

    <form method="get" class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4">
      <?php helper('laporan'); $pSel = (string)($periode ?? ''); $rSel = (int)($rencanaSel ?? 0); $iSel = (int)($indikatorSel ?? 0); $plSel = (int)($pelaksanaSel ?? 0); ?>
      <div>
        <label class="block text-xs text-slate-600 mb-1">Periode</label>
        <select name="periode" class="w-full border rounded-lg px-3 py-2" required>
          <option value="">Pilih</option>
          <?php foreach (listPeriode() as $v): ?>
            <option value="<?= esc($v) ?>" <?= $pSel===$v?'selected':''; ?>><?= esc(str_replace('_',' Bulan ', $v)) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label class="block text-xs text-slate-600 mb-1">Rencana</label>
        <select name="rencana" id="rencana" class="w-full border rounded-lg px-3 py-2" required>
          <option value="">Pilih</option>
          <?php foreach (listRencana() as $r): ?>
            <option value="<?= (int)$r['id'] ?>" <?= $rSel===(int)$r['id']?'selected':''; ?>><?= esc(($r['kode'] ?? '').' - '.($r['aksi'] ?? '')) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label class="block text-xs text-slate-600 mb-1">Indikator</label>
        <select name="indikator" id="indikator" class="w-full border rounded-lg px-3 py-2">
          <option value="">Pilih</option>
        </select>
      </div>
      <div>
        <label class="block text-xs text-slate-600 mb-1">Pelaksana</label>
        <select name="pelaksana" class="w-full border rounded-lg px-3 py-2">
          <option value="">Pilih</option>
          <?php foreach (listPelaksana() as $lv1): ?>
            <option value="<?= (int)$lv1['id'] ?>" <?= $plSel===(int)$lv1['id']?'selected':''; ?>><?= esc($lv1['level1'] ?? '') ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="md:col-span-2">
        <button class="px-4 py-2 rounded-lg bg-emerald-600 text-white hover:bg-emerald-700">Filter Sekarang</button>
        <a href="<?= site_url('admin/capaian_output') ?>" class="px-4 py-2 rounded-lg border bg-white hover:bg-slate-50 ml-2">Reset</a>
      </div>
    </form>
  </div>

  <?php if (!empty($periode) && !empty($rencanaSel)): ?>
    <div class="bg-white rounded-2xl shadow p-6 mt-6">
      <?php
        $merged = mergeCapaian($capaian ?? []);
        $headers = [
          ['key' => 'no', 'label' => 'No', 'noSort' => true],
          ['key' => 'pelaksana', 'label' => 'Pelaksana'],
          ['key' => 'total_output', 'label' => 'Jumlah Output', 'align' => 'right'],
        ];
        $tableRows = array_map(function($v){
          return [
            'pelaksana' => (string)($v['level2'] ?? '-'),
            'total_output' => (string)($v['total_output'] ?? '0'),
          ];
        }, $merged);
        echo view('components/data-table', [
          'id' => 'dt_capaian_output',
          'headers' => $headers,
          'rows' => $tableRows,
          'pageSize' => 10,
        ]);
      ?>
    </div>
  <?php endif; ?>

  <script>
    (function(){
      const selRen = document.getElementById('rencana');
      const selInd = document.getElementById('indikator');
      const selectedInd = <?= json_encode((int)($indikatorSel ?? 0)) ?>;
      function loadIndikator(rid, preselect){
        if (!rid) { selInd.innerHTML = '<option value="">Pilih</option>'; return; }
        fetch('<?= site_url('admin/capaian_output/indikator') ?>?rencana='+encodeURIComponent(rid), { headers: { 'X-Requested-With':'XMLHttpRequest' }})
          .then(r=>r.json())
          .then(d=>{
            const items = (d&&d.items)||[];
            selInd.innerHTML = '<option value="">Pilih</option>' + items.map(it=>{
              const id = parseInt(it.id); const lab = String(it.indikator||'');
              const sel = preselect && id===preselect ? ' selected' : '';
              return `<option value="${id}"${sel}>${lab}</option>`;
            }).join('');
          });
      }
      selRen && selRen.addEventListener('change', function(){ loadIndikator(parseInt(this.value)||0, 0); });
      // initial
      if (selRen && parseInt(selRen.value)) { loadIndikator(parseInt(selRen.value)||0, selectedInd); }
    })();
  </script>

<?= view('layouts/dashboard_footer') ?>
