<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Laporan',
  'active' => 'laporan',
  'breadcrumb' => $breadcrumb ?? ['Admin','Laporan']
]) ?>

  <?php if (!empty($yearRows)): ?>
    <div class="bg-white rounded-2xl shadow p-6 mt-6">
      <?php
        $headers = [
          ['key' => 'no', 'label' => 'No', 'noSort' => true],
          ['key' => 'tahun', 'label' => 'Tahun'],
          ['key' => 'jumlah', 'label' => 'Jumlah Aksi', 'align' => 'right'],
        ];
        echo '<h2 class="text-lg font-semibold mb-1">Tahun</h2>';
        echo '<p class="text-sm text-slate-500 mb-4">Anda dapat memilih laporan berdasarkan field di bawah</p>';
        $prefixBase = isset($basePrefix) && $basePrefix ? $basePrefix : 'admin';
        $tableRows = array_map(function($v) use ($prefixBase){
          $tahun = (string)($v['tahun'] ?? '-');
          $prefix = $prefixBase;
          $href = base_url($prefix.'/laporan/rencana').'?tahun='.$tahun.'&status=true';
          return [
            'tahun' => '<a class="text-sky-700 hover:underline" href="'.esc($href).'">'.esc($tahun).'</a>',
            'jumlah' => '<a class="text-sky-700 hover:underline" href="'.esc($href).'">'.esc((string)($v['jumlah'] ?? '0')).'</a>',
          ];
        }, $yearRows);
        echo view('components/data-table', [
          'id' => 'dt_years',
          'headers' => array_map(function($h){ $k=$h['key']??''; if($k==='tahun'||$k==='jumlah'){ $h['raw']=true; } return $h; }, $headers),
          'rows' => $tableRows,
          'pageSize' => 10,
          'rowLink' => true,
        ]);
      ?>
    </div>
  <?php endif; ?>
<?= view('layouts/dashboard_footer') ?>
