<!--
  // Export utilities
  function getExportData(){
    const { filtered } = compute();
    const cols = headers.filter(h=>h.key!=="actions");
    const head = cols.map(h=>h.label||h.key);
    const data = filtered.map((r, i)=> cols.map(h=> h.key==='no' ? String(i+1) : String(r[h.key] ?? '')));
    return { head, data };
  }
  function downloadBlob(filename, mime, content){
    const blob = new Blob([content], {type: mime});
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = filename; a.click();
    setTimeout(()=>URL.revokeObjectURL(url), 500);
  }
  function exportCSV(){
    const { head, data } = getExportData();
    const esc = v=> '"'+String(v).replace(/"/g,'""')+'"';
    const lines = [head.map(esc).join(',')].concat(data.map(row=>row.map(esc).join(',')));
    downloadBlob((cid||'table')+'-export.csv', 'text/csv;charset=utf-8', lines.join('\n'));
  }
  function exportPrint(){
    const { head, data } = getExportData();
    const w = window.open('', '_blank');
    const table = '<table border="1" cellspacing="0" cellpadding="6" style="border-collapse:collapse;width:100%;font:12px system-ui, -apple-system, Segoe UI, Roboto">'
      +'<thead><tr>'+head.map(h=>'<th style="text-align:left;background:#f1f5f9">'+h+'</th>').join('')+'</tr></thead>'
      +'<tbody>'+data.map(row=>'<tr>'+row.map(c=>'<td>'+c+'</td>').join('')+'</tr>').join('')+'</tbody></table>';
    w.document.write('<html><head><title>Print</title></head><body>'+table+'</body></html>');
    w.document.close(); w.focus(); w.print();
  }
  async function exportPDF(){
    const { head, data } = getExportData();
    try {
      // try load jsPDF UMD if not present
      let jsPDF = window.jspdf && window.jspdf.jsPDF; 
      if (!jsPDF) {
        await new Promise((res, rej)=>{
          const s = document.createElement('script'); s.src='https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js'; s.onload=res; s.onerror=rej; document.head.appendChild(s);
        });
        jsPDF = window.jspdf && window.jspdf.jsPDF;
      }
      if (!jsPDF) throw new Error('jsPDF not available');
      const doc = new jsPDF({orientation: 'p', unit: 'pt', format: 'a4'});
      const margin = 36; let x = margin, y = margin;
      const lineHeight = 16; const pageWidth = doc.internal.pageSize.getWidth() - margin*2;
      // simple column widths
      const cols = head.length; const colWidth = pageWidth / cols;
      doc.setFontSize(12);
      // header
      head.forEach((h, i)=>{ doc.text(String(h), x + i*colWidth, y); });
      y += lineHeight;
      // rows
      data.forEach(row => {
        if (y > doc.internal.pageSize.getHeight() - margin) { doc.addPage(); y = margin; }
        row.forEach((c, i)=>{ doc.text(String(c), x + i*colWidth, y); });
        y += lineHeight;
      });
      doc.save((cid||'table')+'-export.pdf');
    } catch (e) {
      // fallback to print
      exportPrint();
    }
  }

  // Bind export buttons
  const btnPrint = document.getElementById(cid+'_btn_print');
  const btnExcel = document.getElementById(cid+'_btn_excel');
  const btnPDF = document.getElementById(cid+'_btn_pdf');
  if (btnPrint) btnPrint.addEventListener('click', function(){ exportPrint(); });
  if (btnExcel) btnExcel.addEventListener('click', function(){ exportCSV(); });
  if (btnPDF) btnPDF.addEventListener('click', function(){ exportPDF(); });
-->
<?php
/**
 * Simple reusable data table component with client-side search, sort, entries, and pagination.
 *
 * Usage example:
 * echo view('components/data-table', [
 *   'id' => 'levelsTable', // optional but recommended unique id
 *   'headers' => [ ['key' => 'id', 'label' => 'ID'], ['key' => 'name', 'label' => 'Nama'], ['key' => 'actions', 'label' => 'Aksi', 'raw' => true] ],
 *   'rows' => $rows, // array of associative rows: ['id' => 1, 'name' => 'Foo']
 *   'pageSize' => 10, // optional default page size
 * ]);
 */

$cid = isset($id) && $id !== '' ? preg_replace('/[^a-zA-Z0-9_-]/', '', (string)$id) : ('dt'.substr(md5(uniqid('', true)),0,8));
$rowLink = !empty($rowLink);
$cols = array_values($headers ?? []);
$data = array_values($rows ?? []);
$defaultPage = max(1, (int)($page ?? 1));
$defaultSize = in_array((int)($pageSize ?? 10), [5,10,25,50,100], true) ? (int)$pageSize : 10;
?>
<div id="<?= esc($cid) ?>" class="w-full" <?= $rowLink ? 'data-row-link="1"' : '' ?>>
  <div class="flex flex-col sm:flex-row gap-2 sm:items-center sm:justify-between mb-3">
    <div class="inline-flex items-center gap-2 text-sm">
      <label for="<?= esc($cid) ?>_entries" class="text-sky-700">Entries</label>
      <select id="<?= esc($cid) ?>_entries" class="border rounded px-2 py-1 text-sm focus:outline-none focus:ring-2 focus:ring-sky-500 focus:border-sky-500">
        <?php foreach ([5,10,25,50,100] as $opt): ?>
          <option value="<?= $opt ?>" <?= $opt===$defaultSize?'selected':'' ?>><?= $opt ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="flex items-center gap-2">
      <div class="hidden sm:flex items-center">
        <div class="inline-flex items-center gap-2 rounded-lg border border-slate-200 bg-white shadow-sm px-3 py-1">
          <span class="text-[12px] uppercase tracking-wide text-slate-500 font-bold">Export</span>
          <button id="<?= esc($cid) ?>_btn_print" class="inline-flex items-center justify-center h-6 px-1.5 rounded-md bg-sky-600 text-white hover:bg-sky-700" title="Print">
            <i data-lucide="printer" class="w-4 h-4"></i>
          </button>
          <button id="<?= esc($cid) ?>_btn_excel" class="inline-flex items-center justify-center h-6 px-1.5 rounded-md bg-emerald-600 text-white hover:bg-emerald-700" title="Export Excel">
            <i data-lucide="file-spreadsheet" class="w-4 h-4"></i>
          </button>
          <button id="<?= esc($cid) ?>_btn_pdf" class="inline-flex items-center justify-center h-6 px-1.5 rounded-md bg-rose-600 text-white hover:bg-rose-700" title="Export PDF">
            <i data-lucide="file-text" class="w-4 h-4"></i>
          </button>
        </div>
      </div>
      <div class="relative">
        <input id="<?= esc($cid) ?>_search" type="text" placeholder="Search..." class="w-full sm:w-64 border rounded-lg pl-8 pr-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-sky-500 focus:border-sky-500" />
        <svg class="w-4 h-4 absolute left-2 top-2.5 text-sky-400" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/></svg>
      </div>
    </div>
  </div>

  <div class="bg-white rounded-2xl shadow border border-slate-200 overflow-hidden">
    <div class="overflow-x-auto">
      <table class="min-w-full table-auto divide-y divide-sky-100">
        <thead class="bg-sky-50 sticky top-0 z-10">
          <tr>
            <?php foreach ($cols as $h): $key = (string)($h['key'] ?? ''); $label = (string)($h['label'] ?? $key); $align = (string)($h['align'] ?? ($key==='actions' ? 'right' : 'left')); $noSort = !empty($h['noSort']) || $key==='actions'; ?>
              <th data-key="<?= esc($key) ?>" data-nosort="<?= $noSort ? '1':'0' ?>" class="px-4 py-2 <?= $align==='right' ? 'text-right' : 'text-left' ?> text-xs font-semibold text-sky-700 select-none <?= $noSort ? '' : 'cursor-pointer' ?> <?= $key==='actions' ? 'whitespace-nowrap min-w-[112px] sticky right-0 z-20 bg-sky-50 border-l border-sky-200' : '' ?>">
                <span class="inline-flex items-center gap-1">
                  <span><?= esc($label) ?></span>
                  <span class="sort-indicator opacity-0 text-sky-500">▲</span>
                </span>
              </th>
            <?php endforeach; ?>
          </tr>
        </thead>
        <tbody id="<?= esc($cid) ?>_body" class="divide-y divide-sky-50"></tbody>
      </table>
    </div>
    <div class="flex flex-col sm:flex-row items-center justify-between gap-2 px-3 py-2 bg-sky-50 border-t border-sky-200">
      <div id="<?= esc($cid) ?>_info" class="text-xs text-sky-700">Showing 0 to 0 of 0 entries</div>
      <div class="inline-flex items-center gap-1">
        <button id="<?= esc($cid) ?>_prev" class="px-2 py-1 text-sm rounded border border-sky-300 text-sky-700 bg-white hover:bg-sky-50 disabled:opacity-50">Prev</button>
        <div id="<?= esc($cid) ?>_pages" class="inline-flex items-center gap-1"></div>
        <button id="<?= esc($cid) ?>_next" class="px-2 py-1 text-sm rounded border border-sky-300 text-sky-700 bg-white hover:bg-sky-50 disabled:opacity-50">Next</button>
      </div>
    </div>
  </div>
</div>
<script>
(function(){
  const cid = <?= json_encode($cid) ?>;
  const rows = <?= json_encode($data, JSON_UNESCAPED_UNICODE) ?>;
  const headers = <?= json_encode(array_map(function($h){
    $key = $h['key'] ?? '';
    $align = $h['align'] ?? ($key==='actions' ? 'right' : 'left');
    $noSort = !empty($h['noSort']) || $key==='actions';
    return ['key'=>$key, 'label'=>$h['label']??'', 'raw'=>!empty($h['raw']), 'align'=>$align, 'noSort'=>$noSort];
  }, $cols)) ?>;
  let state = {
    page: <?= (int)$defaultPage ?>,
    size: <?= (int)$defaultSize ?>,
    q: '',
    sortKey: headers[0]?.key || '',
    sortDir: 'asc',
  };
  const $ = (sel)=>document.querySelector(sel);
  const root = document.getElementById(cid);
  const body = document.getElementById(cid+'_body');
  const entries = document.getElementById(cid+'_entries');
  const search = document.getElementById(cid+'_search');
  const info = document.getElementById(cid+'_info');
  const prev = document.getElementById(cid+'_prev');
  const next = document.getElementById(cid+'_next');
  const pagesEl = document.getElementById(cid+'_pages');
  const ths = root.querySelectorAll('thead th');

  function normalize(v){ return (v==null? '' : String(v)).toLowerCase(); }
  function cmp(a,b){ if(a===b) return 0; return a>b?1:-1; }

  function compute(){
    let arr = rows.slice();
    if (state.q) {
      const q = state.q.toLowerCase();
      arr = arr.filter(r => headers.some(h => normalize(r[h.key]).includes(q)));
    }
    const activeHeader = headers.find(h=>h.key===state.sortKey);
    if (state.sortKey && !(activeHeader && activeHeader.noSort)) {
      const k = state.sortKey;
      arr.sort((ra, rb)=>{
        const va = normalize(ra[k]);
        const vb = normalize(rb[k]);
        const c = cmp(va, vb);
        return state.sortDir==='asc'? c : -c;
      });
    }
    const total = arr.length;
    const pages = Math.max(1, Math.ceil(total / state.size));
    state.page = Math.min(Math.max(1, state.page), pages);
    const start = (state.page-1)*state.size;
    const slice = arr.slice(start, start+state.size);
    return {slice, total, pages, start, filtered: arr};
  }

  function render(){
    const {slice, total, pages, start} = compute();
    body.innerHTML = slice.map((r, idx)=>{
      const tds = headers.map(h=>{
        const val = r[h.key] ?? '';
        let cell;
        if (h.key === 'no') {
          cell = String(start + idx + 1);
        } else {
          cell = h.raw ? String(val) : escapeHtml(val);
        }
        const alignCls = h.align==='right' ? 'text-right' : 'text-left';
        const extra = h.key==='actions' ? ' whitespace-nowrap min-w-[112px] sticky right-0 z-10 bg-white border-l border-sky-200' : ' break-words';
        return `<td class=\"px-4 py-2 text-sm text-slate-800 ${alignCls}${extra}\">${cell}</td>`;
      }).join('');
      const href = r._href ? String(r._href) : '';
      const rowCls = 'hover:bg-sky-50' + (href ? ' cursor-pointer' : '');
      const rowAttr = href ? ` data-href="${escapeHtml(href)}"` : '';
      return `<tr class=\"${rowCls}\"${rowAttr}>${tds}</tr>`;
    }).join('');
    info.textContent = `Showing ${total? (start+1):0} to ${Math.min(start+slice.length, total)} of ${total} entries`;
    // Render numbered pagination with ellipses
    function pageItems(totalPages, current){
      const items = [];
      const addBtn = (label, page, active=false, disabled=false, ellipsis=false)=>{
        items.push({label, page, active, disabled, ellipsis});
      };
      if (totalPages <= 7) {
        for (let p=1; p<=totalPages; p++) addBtn(String(p), p, p===current);
      } else {
        addBtn('1', 1, current===1);
        const left = Math.max(2, current-1);
        const right = Math.min(totalPages-1, current+1);
        if (left > 2) addBtn('...', null, false, true, true);
        for (let p=left; p<=right; p++) addBtn(String(p), p, p===current);
        if (right < totalPages-1) addBtn('...', null, false, true, true);
        addBtn(String(totalPages), totalPages, current===totalPages);
      }
      return items;
    }
    const items = pageItems(pages, state.page);
    pagesEl.innerHTML = items.map(it => {
      if (it.ellipsis) return `<span class=\"px-2 text-sky-500\">…</span>`;
      const clsBase = 'px-2 py-1 text-sm rounded border';
      const cls = it.active
        ? `${clsBase} border-sky-500 bg-sky-600 text-white`
        : `${clsBase} border-sky-300 text-sky-700 bg-white hover:bg-sky-50`;
      const disabled = it.disabled ? 'disabled' : '';
      const data = it.page ? `data-page=\"${it.page}\"` : '';
      return `<button ${data} class=\"${cls}\" ${disabled}>${it.label}</button>`;
    }).join('');
    prev.disabled = state.page<=1;
    next.disabled = state.page>=pages;
    ths.forEach(th=>{
      const key = th.getAttribute('data-key');
      const nosort = th.getAttribute('data-nosort')==='1';
      const ind = th.querySelector('.sort-indicator');
      if(!ind) return;
      if (nosort) { ind.style.opacity = 0; return; }
      if (key===state.sortKey) { ind.style.opacity = 1; ind.textContent = state.sortDir==='asc'? '▲':'▼'; }
      else { ind.style.opacity = 0; }
    });
    try { if (window.lucide && typeof window.lucide.createIcons === 'function') { window.lucide.createIcons(); } } catch(e) {}
  }

  function escapeHtml(s){
    return String(s).replace(/[&<>\"']/g, function(c){
      return {'&':'&amp;','<':'&lt;','>':'&gt;','\"':'&quot;','\'':'&#39;'}[c] || c;
    });
  }

  entries.addEventListener('change', function(){ state.size = parseInt(this.value)||10; state.page = 1; render(); });
  search.addEventListener('input', function(){ state.q = this.value||''; state.page = 1; render(); });
  prev.addEventListener('click', function(){ if(state.page>1){ state.page--; render(); }});
  next.addEventListener('click', function(){ state.page++; render(); });
  pagesEl.addEventListener('click', function(e){
    const btn = e.target && e.target.closest('button[data-page]');
    if (!btn) return;
    const p = parseInt(btn.getAttribute('data-page'));
    if (!isNaN(p)) { state.page = p; render(); }
  });
  ths.forEach(th=>{
    th.addEventListener('click', function(){
      const key = this.getAttribute('data-key');
      const nosort = this.getAttribute('data-nosort')==='1';
      if (!key || nosort) return;
      if (state.sortKey === key) { state.sortDir = state.sortDir==='asc'? 'desc':'asc'; }
      else { state.sortKey = key; state.sortDir = 'asc'; }
      render();
    });
  });

  if (root.getAttribute('data-row-link') === '1'){
    root.addEventListener('click', function(e){
      const tr = e.target && e.target.closest && e.target.closest(`#${cid} table tbody tr`);
      if (!tr) return;
      if (e.target.closest && e.target.closest('a[href]')) return; // allow default for direct link clicks
      const dh = tr.getAttribute('data-href');
      if (dh) { window.location.href = dh; return; }
      const a = tr.querySelector('a[href]');
      if (a) { window.location.href = a.getAttribute('href'); }
    });
  }

  // Export utilities inside IIFE
  function getExportData(){
    const { filtered } = compute();
    const cols = headers.filter(h=>h.key!=="actions");
    const head = cols.map(h=>h.label||h.key);
    const data = filtered.map((r, i)=> cols.map(h=> h.key==='no' ? String(i+1) : String(r[h.key] ?? '')));
    return { head, data };
  }
  function downloadBlob(filename, mime, content){
    const blob = new Blob([content], {type: mime});
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = filename; a.click();
    setTimeout(()=>URL.revokeObjectURL(url), 500);
  }
  function exportCSV(){
    const { head, data } = getExportData();
    const esc = v=> '"'+String(v).replace(/"/g,'""')+'"';
    const lines = [head.map(esc).join(',')].concat(data.map(row=>row.map(esc).join(',')));
    downloadBlob((cid||'table')+'-export.csv', 'text/csv;charset=utf-8', lines.join('\n'));
  }
  function exportPrint(){
    const { head, data } = getExportData();
    const w = window.open('', '_blank');
    const table = '<table border="1" cellspacing="0" cellpadding="6" style="border-collapse:collapse;width:100%;font:12px system-ui, -apple-system, Segoe UI, Roboto">'
      +'<thead><tr>'+head.map(h=>'<th style="text-align:left;background:#f1f5f9">'+h+'</th>').join('')+'</tr></thead>'
      +'<tbody>'+data.map(row=>'<tr>'+row.map(c=>'<td>'+c+'</td>').join('')+'</tr>').join('')+'</tbody></table>';
    w.document.write('<html><head><title>Print</title></head><body>'+table+'</body></html>');
    w.document.close(); w.focus(); w.print();
  }
  async function exportPDF(){
    const { head, data } = getExportData();
    try {
      let jsPDF = window.jspdf && window.jspdf.jsPDF;
      if (!jsPDF) {
        await new Promise((res, rej)=>{ const s=document.createElement('script'); s.src='https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js'; s.onload=res; s.onerror=rej; document.head.appendChild(s); });
        jsPDF = window.jspdf && window.jspdf.jsPDF;
      }
      if (!jsPDF) throw new Error('jsPDF not available');
      const doc = new jsPDF({orientation: 'p', unit: 'pt', format: 'a4'});
      const margin = 36; let x = margin, y = margin; const lineHeight = 16; const pageWidth = doc.internal.pageSize.getWidth() - margin*2;
      const cols = head.length; const colWidth = pageWidth / cols; doc.setFontSize(12);
      head.forEach((h, i)=>{ doc.text(String(h), x + i*colWidth, y); }); y += lineHeight;
      data.forEach(row => { if (y > doc.internal.pageSize.getHeight() - margin) { doc.addPage(); y = margin; } row.forEach((c, i)=>{ doc.text(String(c), x + i*colWidth, y); }); y += lineHeight; });
      doc.save((cid||'table')+'-export.pdf');
    } catch (e) {
      exportPrint();
    }
  }
  const btnPrint = document.getElementById(cid+'_btn_print');
  const btnExcel = document.getElementById(cid+'_btn_excel');
  const btnPDF = document.getElementById(cid+'_btn_pdf');
  if (btnPrint) btnPrint.addEventListener('click', function(){ exportPrint(); });
  if (btnExcel) btnExcel.addEventListener('click', function(){ exportCSV(); });
  if (btnPDF) btnPDF.addEventListener('click', function(){ exportPDF(); });

  render();
})();
</script>
