<?= view('layouts/dashboard_header', [
  'title' => 'Progres',
  'active' => 'laporan',
  'breadcrumb' => ['Eksekutif','Laporan','Progres']
]) ?>

<div class="bg-white rounded-2xl shadow p-6 mt-6">
  <?php
    // Header info (static Monitor text like old_app)
    echo '<div class="grid grid-cols-1 gap-3">';
    echo '<div class="grid grid-cols-[160px_1fr] gap-3 items-start"><div class="text-sm font-semibold">Monitor</div><div class="text-sm">Inpres No 2 Tahun 2020 Tentang RAN P4GN 2020-2024</div></div>';
    echo '<div class="grid grid-cols-[160px_1fr] gap-3 items-start"><div class="text-sm font-semibold">Bidang</div><div class="text-sm">'.esc($rencana['bidang'] ?? '').'</div></div>';
    echo '<div class="grid grid-cols-[160px_1fr] gap-3 items-start"><div class="text-sm font-semibold">Program</div><div class="text-sm">'.esc($rencana['program'] ?? '').'</div></div>';
    echo '<div class="grid grid-cols-[160px_1fr] gap-3 items-start"><div class="text-sm font-semibold">Aksi Rencana</div><div class="text-sm">'.esc($rencana['aksi'] ?? '').'</div></div>';
    // Indikator list
    echo '<div class="grid grid-cols-[160px_1fr] gap-3 items-start"><div class="text-sm font-semibold">Indikator Keberhasilan</div><div class="text-sm">';
    if (!empty($indikator_texts)) {
      if (count($indikator_texts) === 1) { echo esc($indikator_texts[0]); }
      else { foreach ($indikator_texts as $txt) { echo '<div><span class="font-semibold">-</span> '.esc($txt).'</div>'; } }
    }
    echo '</div></div>';
    echo '</div>';

    // Year tabs (simple inline tabs for available tahun centered on provided $tahun)
    echo '<div class="mt-6 border-b border-slate-200 overflow-x-auto"><div class="flex items-center gap-2">';
    $bulanSel = (int)($bulan_selected ?? 12);
    $rid = (string)($rencana['id'] ?? '');
    for ($y = 2020; $y <= 2024; $y++) {
      $active = ($y == $tahun);
      $href = current_url().'?'.http_build_query([
        'rencana_id'=>$rid,
        'pelaksana_id'=> (string)($pelaksana_id ?? ''),
        'periode'=> $y.'_'.$bulanSel,
      ]);
      echo '<a href="'.esc($href).'" class="px-3 py-1.5 text-sm '.($active?'bg-sky-600 text-white rounded-md':'text-slate-700 hover:bg-slate-50 rounded-md').'">'.esc((string)$y).'</a>';
    }
    echo '</div></div>';

    // Render per-indikator blocks
    $db = db_connect();
    foreach (($items ?? []) as $blk) {
      echo '<div class="mt-8">';
      echo '<div class="mb-2 text-slate-800 font-semibold">Indikator Keberhasilan</div>';
      echo '<div class="text-sm text-slate-700 mb-1">'.esc($blk['indikator'] ?? '').'</div>';
      // Ukuran Keberhasilan (Target Spesifik) for the selected tahun
      $spec = $db->table('spesifik_indikator')->select('spesifik_indikator')->where(['indikator_id'=>($blk['id'] ?? 0),'tahun'=>$tahun])->get()->getRowArray();
      echo '<div class="mb-3"><div class="text-sm font-semibold text-slate-700">Ukuran Keberhasilan</div><div class="text-sm">'.esc($spec['spesifik_indikator'] ?? '').'</div></div>';

      echo '<div class="overflow-x-auto"><table class="min-w-full table-auto border border-slate-200 rounded-md">';
      echo '<thead class="bg-slate-50 text-slate-600 text-sm"><tr>'
          .'<th class="px-3 py-2 text-left">Periode</th>'
          .'<th class="px-3 py-2 text-left">Target Spesifik</th>'
          .'<th class="px-3 py-2 text-left">Capaian (%)</th>'
          .'<th class="px-3 py-2 text-left">Data Dukung</th>'
          .'<th class="px-3 py-2 text-center">Status</th>'
          .'<th class="px-3 py-2 text-left">Catatan Evaluator</th>'
          .'</tr></thead>';
      echo '<tbody class="text-sm">';
      foreach (($blk['rows'] ?? []) as $row) {
        $b = (int)($row['bulan'] ?? 0);
        $k = $row['keberhasilan'] ?? null;
        // target spesifik per bulan fallback: use spesifik_indikator text
        $targetSpesifik = $spec['spesifik_indikator'] ?? '';
        echo '<tr class="border-t border-slate-200">';
        echo '<td class="px-3 py-2">Bulan '.esc((string)$b).'</td>';
        echo '<td class="px-3 py-2 align-top">'.esc($targetSpesifik).'</td>';
        echo '<td class="px-3 py-2">';
        if ($k && $k['status_eval'] !== null && $k['progress'] !== null) {
          $pg = (float)$k['progress'];
          $pgPct = number_format($pg, 0).'%' ;
          $barCls = 'bg-sky-600';
          echo '<div class="w-40 sm:w-56">'
              .'<div class="h-4 w-full rounded bg-slate-200 overflow-hidden"><div class="h-4 '.esc($barCls).'" style="width:'.esc((string)(min(100,max(0,$pg)))).'%;"></div></div>'
              .'<div class="text-xs text-slate-600 mt-1">'.esc($pgPct).'</div>'
              .'</div>';
        } else {
          echo '-';
        }
        echo '</td>';
        // Data Dukung
        echo '<td class="px-3 py-2">';
        if ($k && ($k['dukung'] ?? 0) > 0) {
          echo '<span class="inline-flex items-center gap-1 px-2 py-0.5 rounded bg-emerald-100 text-emerald-700 text-xs">'
              .'<span class="w-1.5 h-1.5 rounded-full bg-emerald-600"></span> Sudah di isi</span>';
        } else { echo '-'; }
        echo '</td>';
        // Status
        echo '<td class="px-3 py-2 text-center">';
        if ($k && $k['status_eval'] !== null) {
          if ((int)$k['status_eval'] === 2) {
            echo '<span class="text-emerald-600">&#10003;</span>';
          } elseif ((int)$k['status_eval'] === 3) {
            echo '<span class="text-rose-600">&#10007;</span>';
          } else { echo '-'; }
        } else { echo '-'; }
        echo '</td>';
        // Catatan
        echo '<td class="px-3 py-2">';
        if ($k) {
          $hasAny = false;
          if (!empty($k['catatan_eval'])) { echo '<div>&bull; '.esc($k['catatan_eval']).'</div>'; $hasAny = true; }
          foreach (($k['notes'] ?? []) as $nt) { if ($nt!=='') { echo '<div>&bull; '.esc($nt).'</div>'; $hasAny = true; } }
          if (!$hasAny) { echo '-'; }
        } else { echo '-'; }
        echo '</td>';
        echo '</tr>';
      }
      echo '</tbody></table></div>';
      echo '</div>'; // end indikator block
    }
  ?>
</div>

<?= view('layouts/dashboard_footer') ?>
