<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Upload Laporan</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="min-h-screen bg-slate-100">
  <header class="bg-gradient-to-r from-blue-600 to-indigo-700 text-white">
    <div class="max-w-4xl mx-auto px-4 py-4 flex items-center justify-between">
      <h1 class="text-xl font-semibold">Upload Laporan</h1>
      <nav class="space-x-3">
        <a href="<?= base_url('logout') ?>" class="bg-white/10 hover:bg-white/20 px-3 py-1.5 rounded">Logout</a>
      </nav>
    </div>
  </header>
  <main class="max-w-4xl mx-auto p-4">
    <?php if (session()->getFlashdata('error')): ?>
      <div class="mb-4 bg-red-100 text-red-700 px-4 py-2 rounded"><?= esc(session()->getFlashdata('error')) ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('success')): ?>
      <div class="mb-4 bg-emerald-100 text-emerald-700 px-4 py-2 rounded"><?= esc(session()->getFlashdata('success')) ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-xl shadow p-6">
      <div class="text-sm text-slate-600 mb-4">
        Maksimum ukuran: <strong><?= number_format(($maxSize ?? 0)/1048576, 2) ?> MB</strong>
        • Ekstensi diizinkan: <strong><?= esc(implode(', ', $allowedExt ?? [])) ?></strong>
      </div>
      <form method="post" action="<?= base_url('upload') ?>" enctype="multipart/form-data" class="space-y-4">
        <?= csrf_field() ?>
        <div>
          <label class="block text-sm font-medium text-slate-700">Pilih File</label>
          <input type="file" name="file" required class="mt-1 block w-full text-sm text-slate-700" />
        </div>
        <div class="flex items-center gap-3">
          <button type="submit" class="inline-flex items-center px-4 py-2 rounded bg-indigo-600 text-white hover:bg-indigo-700">Upload</button>
          <a href="<?= base_url('/') ?>" class="text-slate-600 hover:text-slate-800">Kembali</a>
        </div>
      </form>
    </div>
  </main>
</body>
</html>
