<?php
namespace Config;

class Menu
{
    public static function forCurrentUser(): array
    {
        $s = session();
        $roleStr = strtolower((string) ($s->get('role') ?? 'user'));
        $roleId = (int) ($s->get('role_id') ?? 0);
        $parts = explode(' ', $roleStr);
        $last  = end($parts);
        $suffix = trim(strtolower($last ?: ''));

        if (strpos($roleStr, 'admin') !== false) {
            return self::adminMenu($suffix, $roleId);
        }
        if (strpos($roleStr, 'evaluator') !== false) {
            return self::evaluatorMenu();
        }
        if (strpos($roleStr, 'eksekutif') !== false) {
            return self::eksekutifMenu();
        }
        return self::userMenu();
    }

    private static function adminMenu(string $suffix, int $roleId): array
    {
        $items = [
            ['label' => 'Dashboard', 'href' => base_url('admin')],
            ['label' => 'Profile', 'href' => base_url('admin/profile')],
            ['label' => 'Dokumentasi', 'href' => base_url('admin/dokumentasi')],
        ];

        if ($suffix === 'provinsi') {
            $items[] = [
                'label' => 'Wilayah',
                'children' => [
                    ['label' => 'Pemda TK I', 'href' => base_url('admin/master/level3?id=' . ((int) (session('level2') ?? 0)))],
                    ['label' => 'Pemda TK II', 'href' => base_url('admin/master/level2?id=6')],
                ],
            ];
        } elseif ($suffix === 'kab/kota') {
            $items[] = ['label' => 'Wilayah', 'href' => base_url('admin/master/level3?id=' . ((int) (session('level2') ?? 0)))];
        } else {
            $items[] = [
                'label' => 'Master',
                'children' => [
                    ['label' => 'Level', 'href' => base_url('admin/master/level')],
                    ['label' => 'Group Wilayah', 'href' => base_url('admin/master/group_wilayah')],
                    ['label' => 'Wilayah', 'href' => base_url('admin/master/wilayah')],
                    ['label' => 'Role', 'href' => base_url('admin/master/role')],
                    ['label' => 'Satuan', 'href' => base_url('admin/master/satuan')],
                ],
            ];
        }

        $items[] = ['label' => 'Management User', 'href' => base_url('admin/user')];
        if ($roleId === 1) {
            $items[] = ['label' => 'Peraturan Presiden', 'href' => base_url('admin/bidang')];
        }
        $items[] = ['label' => 'Pemantauan RAN', 'href' => base_url('admin/pemantauan')];
        if ($suffix === 'pusat') {
            $laporanChildren = [ ['label' => 'Periode', 'href' => base_url('admin/periode')] ];
            $laporanChildren[] = ['label' => 'Capaian Output', 'href' => base_url('admin/capaian_output')];
            $laporanChildren[] = ['label' => 'Rangking', 'href' => base_url('admin/rangking')];
            $items[] = ['label' => 'Laporan', 'children' => $laporanChildren];
        }
        if ($suffix === 'pusat') {
            $items[] = [
                'label' => 'Setting',
                'children' => [
                    ['label' => 'Periode', 'href' => base_url('admin/setting')],
                    ['label' => 'Dokumentasi', 'href' => base_url('admin/doc')],
                ],
            ];
        }
        return $items;
    }

    private static function evaluatorMenu(): array
    {
        return [
            ['label' => 'Dashboard', 'href' => base_url('evaluator')],
            ['label' => 'Profile', 'href' => base_url('evaluator/profile')],
            ['label' => 'Dokumentasi', 'href' => base_url('evaluator/dokumentasi')],
            ['label' => 'Permohonan', 'href' => base_url('evaluator/permohonan')],
            ['label' => 'Laporan', 'href' => base_url('evaluator/laporan')],
        ];
    }

    private static function eksekutifMenu(): array
    {
        return [
            ['label' => 'Profile', 'href' => base_url('eksekutif/profile')],
            ['label' => 'Laporan', 'href' => base_url('eksekutif/laporan')],
        ];
    }

    private static function userMenu(): array
    {
        return [
            ['label' => 'Dashboard', 'href' => base_url('user')],
            ['label' => 'Profil', 'href' => base_url('user/profile')],
            ['label' => 'Dokumentasi', 'href' => base_url('user/dokumentasi')],
            ['label' => 'PK RAN', 'href' => base_url('user/pkran')],
            ['label' => 'Pelaporan Aksi', 'href' => base_url('user/rencana')],
            ['label' => 'Lihat Laporan', 'href' => base_url('user/laporan')],
        ];
    }
}
