<?php

use CodeIgniter\Router\RouteCollection;
use Config\Services;

/**
 * @var RouteCollection $routes
 */
$routes = Services::routes();

$routes->get('/', function() { return redirect()->to(base_url('login')); });

// Expose Eksekutif Progres Detail for any logged-in role (admin can access eksekutif link)
$routes->get('eksekutif/progres/detail', '\\Modules\\Eksekutif\\Controllers\\Progres::detail', ['filter' => 'auth']);
$routes->get('_healthz', function() { return 'OK'; });

// Auth
$routes->get('login', '\\Modules\\Auth\\Controllers\\Auth::login');
$routes->post('auth/attempt', '\\Modules\\Auth\\Controllers\\Auth::attempt');
$routes->get('logout', '\\Modules\\Auth\\Controllers\\Auth::logout');

// Dashboards per role (protected by auth)
// Role dashboards with role-specific auth
$routes->get('admin', '\\Modules\\Admin\\Controllers\\Dashboard::index', ['filter' => 'auth:admin']);
$routes->group('admin', ['filter' => 'auth:admin'], static function(RouteCollection $routes) {
    $routes->get('profile', '\\Modules\\Admin\\Controllers\\Profile::index');
    $routes->post('profile', '\\Modules\\Admin\\Controllers\\Profile::update');
    $routes->get('dokumentasi', '\\Modules\\Admin\\Controllers\\Dokumentasi::index');
    // Program & Rencana pages (from Bidang/Program details)
    $routes->get('program', '\\Modules\\Admin\\Controllers\\Program::index');
    $routes->get('program/edit/(:num)', '\\Modules\\Admin\\Controllers\\Program::edit/$1');
    $routes->post('program/update/(:num)', '\\Modules\\Admin\\Controllers\\Program::update/$1');
    $routes->post('program/delete/(:num)', '\\Modules\\Admin\\Controllers\\Program::delete/$1');
    $routes->get('rencana', '\\Modules\\Admin\\Controllers\\Rencana::index');
    $routes->get('rencana/edit/(:num)', '\\Modules\\Admin\\Controllers\\Rencana::edit/$1');
    $routes->post('rencana/update/(:num)', '\\Modules\\Admin\\Controllers\\Rencana::update/$1');
    $routes->post('rencana/delete/(:num)', '\\Modules\\Admin\\Controllers\\Rencana::delete/$1');
    $routes->get('rencana/indikator/(:num)', '\\Modules\\Admin\\Controllers\\Rencana::indikator/$1');
    $routes->post('rencana/indikator/store', '\\Modules\\Admin\\Controllers\\Rencana::indikatorStore');
    $routes->post('rencana/indikator/delete/(:num)', '\\Modules\\Admin\\Controllers\\Rencana::indikatorDelete/$1');
    $routes->get('rencana/pelaksana/(:num)', '\\Modules\\Admin\\Controllers\\Rencana::pelaksana/$1');
    $routes->get('rencana/pelaksana/form', '\\Modules\\Admin\\Controllers\\Rencana::pelaksanaForm');
    $routes->post('rencana/pelaksana/store', '\\Modules\\Admin\\Controllers\\Rencana::pelaksanaStore');
    $routes->post('rencana/pelaksana/delete/(:num)', '\\Modules\\Admin\\Controllers\\Rencana::pelaksanaDelete/$1');
    $routes->post('rencana/pelaksana/auto_general/(:num)', '\\Modules\\Admin\\Controllers\\Rencana::pelaksanaAutoGeneral/$1');
    $routes->get('rencana/pelaksana/options/level2', '\\Modules\\Admin\\Controllers\\Rencana::pelaksanaOptionsLevel2');
    $routes->get('rencana/pelaksana/options/level3', '\\Modules\\Admin\\Controllers\\Rencana::pelaksanaOptionsLevel3');
    $routes->group('master', static function(RouteCollection $routes) {
        $routes->get('level', '\\Modules\\Admin\\Controllers\\MasterLevel::index');
        $routes->get('level2', '\\Modules\\Admin\\Controllers\\MasterLevel2::index');
        $routes->get('level3', '\\Modules\\Admin\\Controllers\\MasterLevel3::index');
        // Level2 CRUD
        $routes->get('level2/create', '\\Modules\\Admin\\Controllers\\MasterLevel2::create');
        $routes->post('level2/store', '\\Modules\\Admin\\Controllers\\MasterLevel2::store');
        $routes->get('level2/show/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel2::show/$1');
        $routes->get('level2/edit/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel2::edit/$1');
        $routes->post('level2/update/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel2::update/$1');
        $routes->post('level2/delete/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel2::delete/$1');
        // Level3 CRUD
        $routes->get('level3/create', '\\Modules\\Admin\\Controllers\\MasterLevel3::create');
        $routes->post('level3/store', '\\Modules\\Admin\\Controllers\\MasterLevel3::store');
        $routes->get('level3/show/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel3::show/$1');
        $routes->get('level3/edit/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel3::edit/$1');
        $routes->post('level3/update/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel3::update/$1');
        $routes->post('level3/delete/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel3::delete/$1');
        $routes->get('group_wilayah', '\\Modules\\Admin\\Controllers\\MasterGroupWilayah::index');
        $routes->get('wilayah', '\\Modules\\Admin\\Controllers\\MasterWilayah::index');
        $routes->get('role', '\\Modules\\Admin\\Controllers\\MasterRole::index');
        $routes->get('satuan', '\\Modules\\Admin\\Controllers\\MasterSatuan::index');

        // Role CRUD
        $routes->get('role/create', '\\Modules\\Admin\\Controllers\\MasterRole::create');
        $routes->post('role/store', '\\Modules\\Admin\\Controllers\\MasterRole::store');
        $routes->get('role/show/(:num)', '\\Modules\\Admin\\Controllers\\MasterRole::show/$1');
        $routes->get('role/edit/(:num)', '\\Modules\\Admin\\Controllers\\MasterRole::edit/$1');
        $routes->post('role/update/(:num)', '\\Modules\\Admin\\Controllers\\MasterRole::update/$1');
        $routes->post('role/delete/(:num)', '\\Modules\\Admin\\Controllers\\MasterRole::delete/$1');

        // Wilayah CRUD
        $routes->get('wilayah/create', '\\Modules\\Admin\\Controllers\\MasterWilayah::create');
        $routes->post('wilayah/store', '\\Modules\\Admin\\Controllers\\MasterWilayah::store');
        $routes->get('wilayah/show/(:num)', '\\Modules\\Admin\\Controllers\\MasterWilayah::show/$1');
        $routes->get('wilayah/edit/(:num)', '\\Modules\\Admin\\Controllers\\MasterWilayah::edit/$1');
        $routes->post('wilayah/update/(:num)', '\\Modules\\Admin\\Controllers\\MasterWilayah::update/$1');
        $routes->post('wilayah/delete/(:num)', '\\Modules\\Admin\\Controllers\\MasterWilayah::delete/$1');

        // Group Wilayah CRUD
        $routes->get('group_wilayah/create', '\\Modules\\Admin\\Controllers\\MasterGroupWilayah::create');
        $routes->post('group_wilayah/store', '\\Modules\\Admin\\Controllers\\MasterGroupWilayah::store');
        $routes->get('group_wilayah/show/(:num)', '\\Modules\\Admin\\Controllers\\MasterGroupWilayah::show/$1');
        $routes->get('group_wilayah/edit/(:num)', '\\Modules\\Admin\\Controllers\\MasterGroupWilayah::edit/$1');
        $routes->post('group_wilayah/update/(:num)', '\\Modules\\Admin\\Controllers\\MasterGroupWilayah::update/$1');
        $routes->post('group_wilayah/delete/(:num)', '\\Modules\\Admin\\Controllers\\MasterGroupWilayah::delete/$1');

        // Satuan CRUD
        $routes->get('satuan/create', '\\Modules\\Admin\\Controllers\\MasterSatuan::create');
        $routes->post('satuan/store', '\\Modules\\Admin\\Controllers\\MasterSatuan::store');
        $routes->get('satuan/show/(:num)', '\\Modules\\Admin\\Controllers\\MasterSatuan::show/$1');
        $routes->get('satuan/edit/(:num)', '\\Modules\\Admin\\Controllers\\MasterSatuan::edit/$1');
        $routes->post('satuan/update/(:num)', '\\Modules\\Admin\\Controllers\\MasterSatuan::update/$1');
        $routes->post('satuan/delete/(:num)', '\\Modules\\Admin\\Controllers\\MasterSatuan::delete/$1');

        // Level1 CRUD
        $routes->get('level/create', '\\Modules\\Admin\\Controllers\\MasterLevel::create');
        $routes->post('level/store', '\\Modules\\Admin\\Controllers\\MasterLevel::store');
        $routes->get('level/show/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel::show/$1');
        $routes->get('level/edit/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel::edit/$1');
        $routes->post('level/update/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel::update/$1');
        $routes->post('level/delete/(:num)', '\\Modules\\Admin\\Controllers\\MasterLevel::delete/$1');
    });

    // Management User
    $routes->get('user', '\\Modules\\Admin\\Controllers\\ManagementUser::index');
    $routes->get('user/create', '\\Modules\\Admin\\Controllers\\ManagementUser::create');
    $routes->post('user/store', '\\Modules\\Admin\\Controllers\\ManagementUser::store');
    $routes->get('user/show/(:num)', '\\Modules\\Admin\\Controllers\\ManagementUser::show/$1');
    $routes->get('user/edit/(:num)', '\\Modules\\Admin\\Controllers\\ManagementUser::edit/$1');
    $routes->post('user/update/(:num)', '\\Modules\\Admin\\Controllers\\ManagementUser::update/$1');
    $routes->post('user/delete/(:num)', '\\Modules\\Admin\\Controllers\\ManagementUser::delete/$1');
    $routes->post('user/reset-password/(:num)', '\\Modules\\Admin\\Controllers\\ManagementUser::resetPassword/$1');

    // Settings Periode
    $routes->get('setting', '\\Modules\\Admin\\Controllers\\Setting::index');
    $routes->post('setting/update', '\\Modules\\Admin\\Controllers\\Setting::update');
    $routes->post('setting/update_revisi', '\\Modules\\Admin\\Controllers\\Setting::updateRevisi');

    // Settings Dokumentasi (management)
    $routes->get('doc', '\\Modules\\Admin\\Controllers\\Doc::index');
    $routes->get('doc/form', '\\Modules\\Admin\\Controllers\\Doc::form');
    $routes->get('doc/edit/(:num)', '\\Modules\\Admin\\Controllers\\Doc::edit/$1');
    $routes->post('doc/store', '\\Modules\\Admin\\Controllers\\Doc::store');
    $routes->post('doc/update/(:num)', '\\Modules\\Admin\\Controllers\\Doc::update/$1');
    $routes->post('doc/delete/(:num)', '\\Modules\\Admin\\Controllers\\Doc::delete/$1');

    // Pemantauan RAN
    $routes->get('pemantauan', '\\Modules\\Admin\\Controllers\\Pemantauan::index');

    // Laporan - Capaian Output
    $routes->get('capaian_output', '\\Modules\\Admin\\Controllers\\CapaianOutput::index');
    $routes->get('capaian_output/indikator', '\\Modules\\Admin\\Controllers\\CapaianOutput::indikator');

    // Laporan - Rangking
    $routes->get('rangking', '\\Modules\\Admin\\Controllers\\Rangking::index');
    $routes->get('rangking/indikator', '\\Modules\\Admin\\Controllers\\CapaianOutput::indikator');

    // Laporan - Periode
    $routes->get('periode', '\\Modules\\Admin\\Controllers\\Periode::index');
    $routes->get('periode/indikator', '\\Modules\\Admin\\Controllers\\Periode::indikator');
    // Laporan - Rencana (drilldown like old_app)
    $routes->get('laporan/rencana', '\\Modules\\Admin\\Controllers\\Laporan::rencana');
    // Laporan - Indikator (second level drilldown)
    $routes->get('laporan/indikator', '\\Modules\\Admin\\Controllers\\Laporan::indikator');
    // Laporan - Detail (alternate drilldown path like old_app)
    $routes->get('laporan/detail', '\\Modules\\Admin\\Controllers\\Laporan::detail');
    // Back-compat alias like old_app
    $routes->get('laporan', '\\Modules\\Admin\\Controllers\\Periode::index');

    // Instruksi Presiden (Bidang)
    $routes->get('bidang', '\\Modules\\Admin\\Controllers\\Bidang::index');
    $routes->get('bidang/create', '\\Modules\\Admin\\Controllers\\Bidang::create');
    $routes->post('bidang/store', '\\Modules\\Admin\\Controllers\\Bidang::store');
    $routes->get('bidang/show/(:num)', '\\Modules\\Admin\\Controllers\\Bidang::show/$1');
    $routes->get('bidang/edit/(:num)', '\\Modules\\Admin\\Controllers\\Bidang::edit/$1');
    $routes->post('bidang/update/(:num)', '\\Modules\\Admin\\Controllers\\Bidang::update/$1');
    $routes->post('bidang/delete/(:num)', '\\Modules\\Admin\\Controllers\\Bidang::delete/$1');
});
$routes->get('evaluator', '\\Modules\\Evaluator\\Controllers\\Dashboard::index', ['filter' => 'auth:evaluator']);
$routes->group('evaluator', ['filter' => 'auth:evaluator'], static function(RouteCollection $routes) {
    $routes->get('profile', '\\Modules\\Evaluator\\Controllers\\Profile::index');
    $routes->post('profile', '\\Modules\\Evaluator\\Controllers\\Profile::update');
    $routes->get('dokumentasi', '\\Modules\\Evaluator\\Controllers\\Dokumentasi::index');
    // Permohonan
    $routes->get('permohonan', '\\Modules\\Evaluator\\Controllers\\Permohonan::index');
    $routes->get('permohonan/rencana', '\\Modules\\Evaluator\\Controllers\\Permohonan::rencana');
    $routes->get('permohonan/detail', '\\Modules\\Evaluator\\Controllers\\Permohonan::detail');
    $routes->post('permohonan/getAll', '\\Modules\\Evaluator\\Controllers\\Permohonan::getAll');
    $routes->post('permohonan/changeStatus', '\\Modules\\Evaluator\\Controllers\\Permohonan::changeStatus');
    $routes->get('permohonan/deletePkran', '\\Modules\\Evaluator\\Controllers\\Permohonan::deletePkran');
    $routes->post('permohonan/updatePkran', '\\Modules\\Evaluator\\Controllers\\Permohonan::updatePkran');
    // Laporan
    $routes->get('laporan', '\\Modules\\Evaluator\\Controllers\\Laporan::index');
    $routes->get('laporan/rencana', '\\Modules\\Evaluator\\Controllers\\Laporan::rencana');
    $routes->get('laporan/detail', '\\Modules\\Evaluator\\Controllers\\Laporan::detail');
    $routes->post('laporan/getAll', '\\Modules\\Evaluator\\Controllers\\Laporan::getAll');
    $routes->post('laporan/changeStatus', '\\Modules\\Evaluator\\Controllers\\Laporan::changeStatus');
    $routes->get('laporan/dataDukung', '\\Modules\\Evaluator\\Controllers\\Laporan::dataDukung');
    $routes->get('laporan/deleteDukung', '\\Modules\\Evaluator\\Controllers\\Laporan::deleteDukung');
    $routes->post('laporan/updateDukung', '\\Modules\\Evaluator\\Controllers\\Laporan::updateDukung');
});
$routes->get('eksekutif', '\\Modules\\Eksekutif\\Controllers\\Profile::index', ['filter' => 'auth:eksekutif']);
$routes->group('eksekutif', ['filter' => 'auth:eksekutif'], static function(RouteCollection $routes) {
    $routes->get('profile', '\\Modules\\Eksekutif\\Controllers\\Profile::index');
    $routes->post('profile', '\\Modules\\Eksekutif\\Controllers\\Profile::update');
    // Laporan
    $routes->get('laporan', '\\Modules\\Eksekutif\\Controllers\\Laporan::index');
    $routes->get('laporan/debug', '\\Modules\\Eksekutif\\Controllers\\Laporan::debug');
    $routes->get('laporan/schema-debug', '\\Modules\\Eksekutif\\Controllers\\Laporan::schemaDebug');
    $routes->get('laporan/rencana', '\\Modules\\Eksekutif\\Controllers\\Laporan::rencana');
    $routes->post('laporan/get-all', '\\Modules\\Eksekutif\\Controllers\\Laporan::getAll');
    $routes->get('laporan/detail', '\\Modules\\Eksekutif\\Controllers\\Laporan::detail');
    // Progres Detail routed globally with generic auth (see below)
    $routes->post('laporan/change-status', '\\Modules\\Eksekutif\\Controllers\\Laporan::changeStatus');
    $routes->get('laporan/data-dukung/(:num)', '\\Modules\\Eksekutif\\Controllers\\Laporan::data_dukung/$1');
});
$routes->get('user', '\\Modules\\User\\Controllers\\Dashboard::index', ['filter' => 'auth:user']);
$routes->group('user', ['filter' => 'auth:user'], static function(RouteCollection $routes) {
    $routes->get('profile', '\\Modules\\User\\Controllers\\Profile::index');
    $routes->post('profile', '\\Modules\\User\\Controllers\\Profile::update');
    $routes->get('dokumentasi', '\\Modules\\User\\Controllers\\Dokumentasi::index');
    $routes->get('pkran', '\\Modules\\User\\Controllers\\PkRan::index');
    $routes->post('pkran/addpkran', '\\Modules\\User\\Controllers\\PkRan::addpkran');
    $routes->get('pkran/setstatus', '\\Modules\\User\\Controllers\\PkRan::setstatus');
    $routes->get('rencana', '\\Modules\\User\\Controllers\\Rencana::index');
    $routes->post('rencana/setProgres', '\\Modules\\User\\Controllers\\Rencana::setProgres');
    $routes->get('laporan', '\\Modules\\User\\Controllers\\Laporan::index');
    $routes->get('laporan/detail', '\\Modules\\User\\Controllers\\Laporan::detail');
});

// Upload (any logged-in role)
$routes->group('', ['filter' => 'auth'], static function(RouteCollection $routes) {
    $routes->get('upload', '\\App\\Controllers\\UploadController::form');
    $routes->post('upload', '\\App\\Controllers\\UploadController::store');
    // API endpoints
    $routes->get('api/user/trend', '\\App\\Controllers\\ApiController::userTrend');
});
