<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class Bidang extends BaseController
{
    private function resolveNameColumn(string $table, array $candidates = ['nama','name','bidang','judul','title']): string {
        try {
            $fields = db_connect()->getFieldNames($table);
            foreach ($candidates as $c) { if (in_array($c, $fields, true)) return $c; }
        } catch (\Throwable $e) {}
        return $candidates[0] ?? 'nama';
    }

    private function nameCol(): string { return $this->resolveNameColumn('bidang', ['nama','name','bidang']); }
    private function codeCol(): string { return $this->resolveNameColumn('bidang', ['kode','code','kode_bidang']); }

    public function index()
    {
        $db = db_connect();
        $col = $this->nameCol();
        $code = $this->codeCol();
        $rows = [];
        try {
            $rows = $db->table('bidang')
                ->select('id, ' . $code . ' as kode, ' . $col . ' as nama')
                ->orderBy($code, 'asc')
                ->orderBy('id', 'asc')
                ->get()->getResultArray();
        } catch (\Throwable $e) { $rows = []; }

        // Compose actions + coalesce
        $no = 1;
        foreach ($rows as &$r) {
            $id = (int)($r['id'] ?? 0);
            $r['no'] = $no++;
            $r['kode'] = trim((string)($r['kode'] ?? '')) !== '' ? (string)$r['kode'] : '-';
            $r['nama'] = trim((string)($r['nama'] ?? '')) !== '' ? (string)$r['nama'] : '-';
            $r['actions'] = '<div class="inline-flex items-center justify-end gap-1">'
                .'<a class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/program?id='.$id).'" title="Details" aria-label="Details"><i data-lucide="search" class="w-4 h-4"></i></a>'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/bidang/edit/'.$id).'" title="Edit" aria-label="Edit"><i data-lucide="pencil" class="w-4 h-4"></i></a>'
                .'<form method="post" action="'.base_url('admin/bidang/delete/'.$id).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'.csrf_field().'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600"><i data-lucide="trash-2" class="w-4 h-4"></i></button></form>'
                .'</div>';
        }
        unset($r);

        return view('Modules\Admin\Views\bidang', [
            'title' => 'Peraturan Presiden',
            'rows' => $rows,
        ]);
    }

    public function create()
    {
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\Admin\Views\bidang_form', [
            'title' => 'Tambah Bidang',
            'action' => base_url('admin/bidang/store'),
            'value' => ['kode' => '', 'nama' => ''],
            'submitLabel' => 'Simpan',
            'modal' => $isModal,
        ]);
    }

    public function store()
    {
        $name = trim((string)$this->request->getPost('name'));
        $kode = trim((string)$this->request->getPost('kode'));
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        $col = $this->nameCol();
        $code = $this->codeCol();
        $data = [$col => $name];
        if ($kode !== '') { $data[$code] = $kode; }
        try { db_connect()->table('bidang')->insert($data); }
        catch (\Throwable $e) { return redirect()->back()->with('error','Gagal menyimpan data'); }
        return redirect()->to(base_url('admin/bidang'))->with('success','Data ditambahkan');
    }

    public function show(int $id)
    {
        $db = db_connect();
        $col = $this->nameCol();
        $code = $this->codeCol();
        $row = $db->table('bidang')->select('id, ' . $code . ' as kode, ' . $col . ' as nama')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/bidang'))->with('error','Data tidak ditemukan');
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\Admin\Views\bidang_show', [
            'title' => 'Detail Bidang',
            'row' => $row,
            'modal' => $isModal,
        ]);
    }

    public function edit(int $id)
    {
        $db = db_connect();
        $col = $this->nameCol();
        $code = $this->codeCol();
        $row = $db->table('bidang')->select('id, ' . $code . ' as kode, ' . $col . ' as nama')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/bidang'))->with('error','Data tidak ditemukan');
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\Admin\Views\bidang_form', [
            'title' => 'Edit Bidang',
            'action' => base_url('admin/bidang/update/'.$id),
            'value' => ['kode' => (string)($row['kode'] ?? ''), 'nama' => (string)($row['nama'] ?? '')],
            'submitLabel' => 'Update',
            'modal' => $isModal,
        ]);
    }

    public function update(int $id)
    {
        $name = trim((string)$this->request->getPost('name'));
        $kode = trim((string)$this->request->getPost('kode'));
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        $col = $this->nameCol();
        $code = $this->codeCol();
        $data = [$col => $name];
        if ($kode !== '') { $data[$code] = $kode; }
        try { db_connect()->table('bidang')->where('id',$id)->update($data); }
        catch (\Throwable $e) { return redirect()->back()->with('error','Gagal memperbarui data'); }
        return redirect()->to(base_url('admin/bidang'))->with('success','Data diperbarui');
    }

    public function delete(int $id)
    {
        try { db_connect()->table('bidang')->where('id',$id)->delete(); }
        catch (\Throwable $e) { return redirect()->to(base_url('admin/bidang'))->with('error','Gagal menghapus data'); }
        return redirect()->to(base_url('admin/bidang'))->with('success','Data dihapus');
    }
}
