<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;
use App\Models\CapaianOutputModel;

class CapaianOutput extends BaseController
{
    public function index()
    {
        helper(['laporan', 'url']);
        $capaian = [];
        $periode = (string)($this->request->getGet('periode') ?? '');
        $rencana = (int)($this->request->getGet('rencana') ?? 0);
        $pelaksana = (int)($this->request->getGet('pelaksana') ?? 0);
        $indikator = (int)($this->request->getGet('indikator') ?? 0);
        // Periode dan rencana wajib; indikator dan pelaksana optional
        if ($periode !== '' && $rencana) {
            [$tahun, $bulan] = explode('_', $periode) + [0=>0,1=>0];
            $tahun = (int)$tahun; $bulan = (int)$bulan;
            $model = new CapaianOutputModel();
            $capaian = $model->getCapaian($rencana, $tahun, $bulan, $pelaksana, $indikator);
        }
        return view('admin/laporan/capaian_output', [
            'title' => 'Laporan - Capaian Output',
            'capaian' => $capaian,
            'periode' => $periode,
            'rencanaSel' => $rencana,
            'pelaksanaSel' => $pelaksana,
            'indikatorSel' => $indikator,
        ]);
    }

    // GET admin/capaian_output/indikator?rencana=ID
    public function indikator()
    {
        $rencanaId = (int)($this->request->getGet('rencana') ?? 0);
        if (!$this->request->isAJAX()) {
            return $this->response->setStatusCode(400)->setBody('Bad Request');
        }
        $items = [];
        if ($rencanaId > 0) {
            try {
                $items = db_connect()->table('indikator')->select('id, indikator')->where('rencana_id', $rencanaId)->get()->getResultArray();
            } catch (\Throwable $e) {
                $items = [];
            }
        }
        return $this->response->setJSON(['items' => $items]);
    }
}
