<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;
use App\Models\StatsModel;
use App\Models\DashboardAdminModel;

class Dashboard extends BaseController
{
    public function index()
    {
        $stats = new StatsModel();
        $dash = new DashboardAdminModel();
        $totalUsers = $stats->totalUsers();
        $totalLaporan = $stats->totalLaporan();
        $capaian = $stats->capaianPercent();

        // Build real table data: latest users
        $db = db_connect();
        $rows = [];
        try {
            $builder = $db->table('user u')
                ->select('u.nama, u.username, r.role')
                ->join('role r', 'r.id = u.role_id', 'left')
                ->orderBy('u.id', 'DESC')
                ->limit(10);
            $results = $builder->get()->getResultArray();
            foreach ($results as $r) {
                $rows[] = [
                    $r['nama'] ?? '-',
                    $r['username'] ?? '-',
                    $r['role'] ?? '-',
                ];
            }
        } catch (\Throwable $e) {
            $rows = [];
        }
        $session = session();
        $roleStr = strtolower((string) ($session->get('role') ?? ''));
        $parts = explode(' ', $roleStr);
        $last = end($parts);
        $suffix = trim(strtolower($last ?: ''));
        $level2Id = (int) ($session->get('level2') ?? 0);
        $wilayahId = (int) ($session->get('wilayah') ?? 0);

        $level1Cards = $dash->getLevel1();
        $level2Top = $dash->getLevel2($level2Id, $wilayahId, $suffix);
        $level3Top = $dash->getLevel3($level2Id, $wilayahId, $suffix);

        $data = [
            'title' => 'Admin Dashboard',
            'cards' => [
                ['title' => 'Total User', 'value' => $totalUsers],
                ['title' => 'Total Laporan', 'value' => $totalLaporan],
                ['title' => 'Capaian', 'value' => $capaian],
            ],
            'table' => [
                'headers' => ['Nama', 'Username', 'Role'],
                'rows' => $rows,
            ],
            'levelSuffix' => $suffix,
            'level1' => $level1Cards,
            'topLevel2' => $level2Top,
            'topLevel3' => $level3Top,
        ];

        return view('Modules\\Admin\\Views\\dashboard', $data);
    }
}
