<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class MasterLevel2 extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $rows = [];
        $level1Id = (int)($this->request->getGet('id') ?? 0); // level1 filter from query
        $wilayahId = 0;
        // Enforce wilayah scoping for admin provinsi (BNNP): override any provided id
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $sessionLevel2 = (int)(session('level2') ?? 0);
            if ($sessionLevel2 > 0) {
                try {
                    $rowL2 = $db->table('level2')->select('wilayah_id')->where('id', $sessionLevel2)->get()->getRowArray();
                    if ($rowL2 && isset($rowL2['wilayah_id'])) {
                        $wilayahId = (int)$rowL2['wilayah_id'];
                    }
                } catch (\Throwable $e) { /* ignore */ }
            }
        }
        try {
            // Detect display column for level2 name
            $fields = $db->getFieldNames('level2');
            $nameCol = 'level2';
            foreach (['level2','nama','name'] as $c) { if (in_array($c, $fields, true)) { $nameCol = $c; break; } }
            $wcol = $this->detectWilayahColumn();
            $builder = $db->table('level2')
                ->select('level2.id as id, level2.' . $nameCol . ' as name, wilayah.wilayah as wilayah')
                ->join('wilayah', 'wilayah.id = level2.' . $wcol, 'left')
                ->orderBy('level2.' . $nameCol,'asc');
            if ($level1Id > 0) {
                $builder->where('level2.level1_id', $level1Id);
            }
            if ($wilayahId > 0) {
                $builder->where('level2.' . $wcol, $wilayahId);
            }
            $rows = $builder->get()->getResultArray();
        } catch (\Throwable $e) {
            $rows = [];
        }

        return view('Modules\\Admin\\Views\\master_level2', [
            'title' => 'Wilayah - Pemda TK II',
            'rows' => $rows,
        ]);
    }

    private function detectNameColumn(): string
    {
        $fields = db_connect()->getFieldNames('level2');
        foreach (['level2','nama','name'] as $c) { if (in_array($c, $fields, true)) return $c; }
        return 'level2';
    }

    private function detectWilayahColumn(): string
    {
        $fields = db_connect()->getFieldNames('level2');
        foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $fields, true)) return $c; }
        return 'wilayah_id';
    }

    public function create()
    {
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        $wilayah = [];
        try {
            $qb = db_connect()->table('wilayah')->select('id, wilayah')->orderBy('wilayah','asc');
            // Restrict options for BNNP/provinsi to own wilayah
            $roleStr = strtolower((string)(session('role') ?? ''));
            if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
                $sessionLevel2 = (int)(session('level2') ?? 0);
                if ($sessionLevel2 > 0) {
                    $wcol = $this->detectWilayahColumn();
                    $rowL2 = db_connect()->table('level2')->select($wcol.' as wilayah_id')->where('id', $sessionLevel2)->get()->getRowArray();
                    if ($rowL2 && isset($rowL2['wilayah_id'])) {
                        $qb->where('id', (int)$rowL2['wilayah_id']);
                    }
                }
            }
            $wilayah = $qb->get()->getResultArray();
        } catch (\Throwable $e) { $wilayah = []; }
        $level1Id = (int)($this->request->getGet('id') ?? 0);
        return view('Modules\\Admin\\Views\\master_level2_form', [
            'title' => 'Tambah Pemda TK II',
            'action' => base_url('admin/master/level2/store' . ($level1Id>0 ? ('?id='.$level1Id) : '')),
            'value' => ['name' => '', 'wilayah_id' => ''],
            'wilayah' => $wilayah,
            'submitLabel' => 'Simpan',
            'modal' => $isModal,
        ]);
    }

    public function store()
    {
        $name = trim((string)$this->request->getPost('name'));
        $level1Id = (int)($this->request->getGet('id') ?? 0);
        $wilayahId = (int)($this->request->getPost('wilayah_id') ?? 0);
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        // Guard: BNNP/provinsi can only use own wilayah
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $sessionLevel2 = (int)(session('level2') ?? 0);
            if ($sessionLevel2 > 0) {
                $wcol = $this->detectWilayahColumn();
                $rowL2 = db_connect()->table('level2')->select($wcol.' as wilayah_id')->where('id', $sessionLevel2)->get()->getRowArray();
                $ownWilayah = (int)($rowL2['wilayah_id'] ?? 0);
                if ($ownWilayah > 0) {
                    if ($wilayahId === 0) { $wilayahId = $ownWilayah; }
                    if ($wilayahId !== $ownWilayah) {
                        return redirect()->back()->with('error','Tidak diperbolehkan memilih wilayah lain');
                    }
                }
            }
        }
        $data = [$this->detectNameColumn() => $name];
        if ($level1Id > 0) { $data['level1_id'] = $level1Id; }
        if ($wilayahId > 0) { $data[$this->detectWilayahColumn()] = $wilayahId; }
        try { db_connect()->table('level2')->insert($data); }
        catch (\Throwable $e) { return redirect()->back()->with('error','Gagal menyimpan data'); }
        session()->setFlashdata('success','Data ditambahkan');
        if ($this->request->isAJAX() || ((string)($this->request->getGet('modal') ?? '') === '1')) {
            return $this->response->setBody('<script>window.top.location = "'.base_url('admin/master/level2'.($level1Id>0?('?id='.$level1Id):'')).'";</script>');
        }
        return redirect()->to(base_url('admin/master/level2'.($level1Id>0?('?id='.$level1Id):'')));
    }

    public function show(int $id)
    {
        $db = db_connect();
        $row = $db->table('level2')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/level2'))->with('error','Data tidak ditemukan');
        // Guard: BNNP/provinsi only own wilayah rows
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $sessionLevel2 = (int)(session('level2') ?? 0);
            $wcol = $this->detectWilayahColumn();
            $rowL2 = $db->table('level2')->select($wcol.' as wilayah_id')->where('id', $sessionLevel2)->get()->getRowArray();
            $ownWilayah = (int)($rowL2['wilayah_id'] ?? 0);
            if ($ownWilayah > 0 && (int)($row[$wcol] ?? 0) !== $ownWilayah) {
                return redirect()->to(base_url('admin/master/level2'))->with('error','Akses ditolak ke wilayah lain');
            }
        }
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_level2_show', [
            'title' => 'Detail Pemda TK II',
            'row' => $row,
            'modal' => $isModal,
        ]);
    }

    public function edit(int $id)
    {
        $db = db_connect();
        $row = $db->table('level2')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/level2'))->with('error','Data tidak ditemukan');
        // Guard: BNNP/provinsi only own wilayah rows
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $sessionLevel2 = (int)(session('level2') ?? 0);
            $rowL2Own = $db->table('level2')->select('wilayah_id')->where('id', $sessionLevel2)->get()->getRowArray();
            $ownWilayah = (int)($rowL2Own['wilayah_id'] ?? 0);
            if ($ownWilayah > 0 && (int)($row['wilayah_id'] ?? 0) !== $ownWilayah) {
                return redirect()->to(base_url('admin/master/level2'))->with('error','Akses ditolak ke wilayah lain');
            }
        }
        $name = $row['level2'] ?? ($row['nama'] ?? ($row['name'] ?? ''));
        $wcol = $this->detectWilayahColumn();
        $wilayahId = (int)($row[$wcol] ?? 0);
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        $wilayah = [];
        try {
            $qb = db_connect()->table('wilayah')->select('id, wilayah')->orderBy('wilayah','asc');
            // Restrict options
            $roleStr = strtolower((string)(session('role') ?? ''));
            if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
                if ($wilayahId > 0) { $qb->where('id', $wilayahId); }
            }
            $wilayah = $qb->get()->getResultArray();
        } catch (\Throwable $e) { $wilayah = []; }
        return view('Modules\\Admin\\Views\\master_level2_form', [
            'title' => 'Edit Pemda TK II',
            'action' => base_url('admin/master/level2/update/'.$id),
            'value' => ['name' => $name, 'wilayah_id' => $wilayahId],
            'wilayah' => $wilayah,
            'submitLabel' => 'Update',
            'modal' => $isModal,
        ]);
    }

    public function update(int $id)
    {
        $name = trim((string)$this->request->getPost('name'));
        $wilayahId = (int)($this->request->getPost('wilayah_id') ?? 0);
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        // Guard: ensure target row belongs to own wilayah and posted wilayah_id stays in scope
        $db = db_connect();
        $row = $db->table('level2')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/level2'))->with('error','Data tidak ditemukan');
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $sessionLevel2 = (int)(session('level2') ?? 0);
            $wcol = $this->detectWilayahColumn();
            $rowL2Own = $db->table('level2')->select($wcol.' as wilayah_id')->where('id', $sessionLevel2)->get()->getRowArray();
            $ownWilayah = (int)($rowL2Own['wilayah_id'] ?? 0);
            if ($ownWilayah > 0) {
                if ((int)($row[$wcol] ?? 0) !== $ownWilayah) {
                    return redirect()->to(base_url('admin/master/level2'))->with('error','Akses ditolak ke wilayah lain');
                }
                if ($wilayahId === 0) { $wilayahId = $ownWilayah; }
                if ($wilayahId !== $ownWilayah) {
                    return redirect()->back()->with('error','Tidak diperbolehkan memilih wilayah lain');
                }
            }
        }
        $data = [$this->detectNameColumn() => $name];
        if ($wilayahId > 0) { $data[$this->detectWilayahColumn()] = $wilayahId; }
        try { db_connect()->table('level2')->where('id',$id)->update($data); }
        catch (\Throwable $e) { return redirect()->back()->with('error','Gagal memperbarui data'); }
        session()->setFlashdata('success','Data diperbarui');
        if ($this->request->isAJAX() || ((string)($this->request->getGet('modal') ?? '') === '1')) {
            $level1Id = (int)($this->request->getGet('id') ?? 0);
            return $this->response->setBody('<script>window.top.location = "'.base_url('admin/master/level2'.($level1Id>0?('?id='.$level1Id):'')).'";</script>');
        }
        $level1Id = (int)($this->request->getGet('id') ?? 0);
        return redirect()->to(base_url('admin/master/level2'.($level1Id>0?('?id='.$level1Id):'')));
    }

    public function delete(int $id)
    {
        $db = db_connect();
        // Guard: only delete within own wilayah
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $row = $db->table('level2')->where('id',$id)->get()->getRowArray();
            if ($row) {
                $sessionLevel2 = (int)(session('level2') ?? 0);
                $wcol = $this->detectWilayahColumn();
                $rowL2Own = $db->table('level2')->select($wcol.' as wilayah_id')->where('id', $sessionLevel2)->get()->getRowArray();
                $ownWilayah = (int)($rowL2Own['wilayah_id'] ?? 0);
                if ($ownWilayah > 0 && (int)($row[$wcol] ?? 0) !== $ownWilayah) {
                    return redirect()->to(base_url('admin/master/level2'))->with('error','Akses ditolak ke wilayah lain');
                }
            }
        }
        try { $db->table('level2')->where('id',$id)->delete(); }
        catch (\Throwable $e) { return redirect()->to(base_url('admin/master/level2'))->with('error','Gagal menghapus data'); }
        return redirect()->to(base_url('admin/master/level2'))->with('success','Data dihapus');
    }
}
