<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class MasterLevel3 extends BaseController
{
    public function index()
    {
        $db = db_connect();
        $rows = [];
        $level2Id = (int)($this->request->getGet('id') ?? 0);
        // For BNNP/provinsi, derive own wilayah and validate/filter scope; if no id, default to session level2
        $roleStr = strtolower((string)(session('role') ?? ''));
        $ownWilayah = 0; $wilayahCol = 'wilayah_id';
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $dbw = db_connect();
            $sessionLevel2 = (int)(session('level2') ?? 0);
            if ($sessionLevel2 > 0) {
                $l2fields = $dbw->getFieldNames('level2');
                foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $l2fields, true)) { $wilayahCol = $c; break; } }
                $rowOwn = $dbw->table('level2')->select($wilayahCol.' as wilayah_id')->where('id',$sessionLevel2)->get()->getRowArray();
                $ownWilayah = (int)($rowOwn['wilayah_id'] ?? 0);
            }
            if ($level2Id > 0 && $ownWilayah > 0) {
                $chk = $dbw->table('level2')->select('id')->where('id',$level2Id)->where($wilayahCol, $ownWilayah)->countAllResults();
                if ($chk === 0) {
                    return redirect()->to(base_url('admin/master/level3'))->with('error','Akses ditolak ke pemda TK II lain');
                }
            } elseif ($level2Id === 0 && $sessionLevel2 > 0) {
                // Default to the user's own level2
                $level2Id = $sessionLevel2;
            }
        }
        try {
            // Detect display column for level3 name
            $fields = $db->getFieldNames('level3');
            $nameCol = 'level3';
            foreach (['level3','nama','name'] as $c) { if (in_array($c, $fields, true)) { $nameCol = $c; break; } }
            $builder = $db->table('level3')
                ->select('level3.id as id, level3.' . $nameCol . ' as name, level2.level2 as parent')
                ->join('level2', 'level2.id = level3.level2_id', 'left')
                ->orderBy('level3.' . $nameCol,'asc');
            if ($level2Id > 0) {
                $builder->where('level3.level2_id', $level2Id);
            }
            $rows = $builder->get()->getResultArray();
        } catch (\Throwable $e) {
            $rows = [];
        }

        return view('Modules\\Admin\\Views\\master_level3', [
            'title' => 'Wilayah - Pemda TK I',
            'rows' => $rows,
        ]);
    }

    private function detectNameColumn(): string
    {
        $fields = db_connect()->getFieldNames('level3');
        foreach (['level3','nama','name'] as $c) { if (in_array($c, $fields, true)) return $c; }
        return 'level3';
    }

    public function create()
    {
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        $level2 = [];
        $prefLevel2 = (int)($this->request->getGet('id') ?? 0);
        try {
            $qb = db_connect()->table('level2')->select('id, level2')->orderBy('level2','asc');
            $roleStr = strtolower((string)(session('role') ?? ''));
            if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
                // restrict to all level2 inside user's wilayah
                $sessionLevel2 = (int)(session('level2') ?? 0);
                if ($sessionLevel2 > 0) {
                    $wcol = 'wilayah_id';
                    $fields = db_connect()->getFieldNames('level2');
                    foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $fields, true)) { $wcol = $c; break; } }
                    $ownRow = db_connect()->table('level2')->select($wcol.' as wilayah_id')->where('id',$sessionLevel2)->get()->getRowArray();
                    $ownWilayah = (int)($ownRow['wilayah_id'] ?? 0);
                    if ($ownWilayah > 0) { $qb->where($wcol, $ownWilayah); }
                }
            }
            $level2 = $qb->get()->getResultArray();
        } catch (\Throwable $e) { $level2 = []; }
        return view('Modules\\Admin\\Views\\master_level3_form', [
            'title' => 'Tambah Pemda TK I',
            'action' => base_url('admin/master/level3/store'),
            'value' => ['name' => '', 'level2_id' => $prefLevel2],
            'level2' => $level2,
            'submitLabel' => 'Simpan',
            'modal' => $isModal,
        ]);
    }

    public function store()
    {
        $name = trim((string)$this->request->getPost('name'));
        $level2Id = (int)($this->request->getPost('level2_id') ?? 0);
        $reqId = (int)($this->request->getGet('id') ?? 0);
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        // Guard: BNNP/provinsi can only use level2 within own wilayah
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $dbv = db_connect();
            $sessionLevel2 = (int)(session('level2') ?? 0);
            $ownWilayah = 0;
            if ($sessionLevel2 > 0) {
                $wcol = 'wilayah_id';
                $fields = $dbv->getFieldNames('level2');
                foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $fields, true)) { $wcol = $c; break; } }
                $ownRow = $dbv->table('level2')->select($wcol.' as wilayah_id')->where('id',$sessionLevel2)->get()->getRowArray();
                $ownWilayah = (int)($ownRow['wilayah_id'] ?? 0);
            }
            // Default posted level2_id from query if missing
            if ($level2Id === 0 && $reqId > 0) { $level2Id = $reqId; }
            if ($ownWilayah > 0) {
                $wcol = 'wilayah_id';
                $fields = $dbv->getFieldNames('level2');
                foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $fields, true)) { $wcol = $c; break; } }
                $chk = $dbv->table('level2')->select('id')->where('id',$level2Id)->where($wcol, $ownWilayah)->countAllResults();
                if ($chk === 0) { return redirect()->back()->with('error','Tidak diperbolehkan memilih pemda TK II lain'); }
            }
        }
        $data = [$this->detectNameColumn() => $name];
        if ($level2Id > 0) { $data['level2_id'] = $level2Id; }
        try { db_connect()->table('level3')->insert($data); }
        catch (\Throwable $e) { return redirect()->back()->with('error','Gagal menyimpan data'); }
        session()->setFlashdata('success','Data ditambahkan');
        $redirId = $level2Id > 0 ? $level2Id : $reqId;
        if ($this->request->isAJAX() || ((string)($this->request->getGet('modal') ?? '') === '1')) {
            return $this->response->setBody('<script>window.top.location = "'.base_url('admin/master/level3'.($redirId>0?('?id='.$redirId):'')).'";</script>');
        }
        return redirect()->to(base_url('admin/master/level3'.($redirId>0?('?id='.$redirId):'')));
    }

    public function show(int $id)
    {
        $db = db_connect();
        $row = $db->table('level3')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/level3'))->with('error','Data tidak ditemukan');
        // Guard: BNNP/provinsi only rows whose parent level2 is within own wilayah
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $dbv = db_connect();
            $sessionLevel2 = (int)(session('level2') ?? 0);
            $wcol = 'wilayah_id';
            $fields = $dbv->getFieldNames('level2');
            foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $fields, true)) { $wcol = $c; break; } }
            $ownRow = $dbv->table('level2')->select($wcol.' as wilayah_id')->where('id',$sessionLevel2)->get()->getRowArray();
            $ownWilayah = (int)($ownRow['wilayah_id'] ?? 0);
            if ($ownWilayah > 0) {
                $parentL2 = (int)($row['level2_id'] ?? 0);
                $chk = $dbv->table('level2')->select('id')->where('id',$parentL2)->where($wcol,$ownWilayah)->countAllResults();
                if ($chk === 0) { return redirect()->to(base_url('admin/master/level3'))->with('error','Akses ditolak ke pemda TK II lain'); }
            }
        }
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        return view('Modules\\Admin\\Views\\master_level3_show', [
            'title' => 'Detail Pemda TK I',
            'row' => $row,
            'modal' => $isModal,
        ]);
    }

    public function edit(int $id)
    {
        $db = db_connect();
        $row = $db->table('level3')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/level3'))->with('error','Data tidak ditemukan');
        // Guard: BNNP/provinsi only rows whose parent level2 is within own wilayah
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $sessionLevel2 = (int)(session('level2') ?? 0);
            $wcol = 'wilayah_id';
            $fields = $db->getFieldNames('level2');
            foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $fields, true)) { $wcol = $c; break; } }
            $ownRow = $db->table('level2')->select($wcol.' as wilayah_id')->where('id',$sessionLevel2)->get()->getRowArray();
            $ownWilayah = (int)($ownRow['wilayah_id'] ?? 0);
            if ($ownWilayah > 0) {
                $parentL2 = (int)($row['level2_id'] ?? 0);
                $chk = $db->table('level2')->select('id')->where('id',$parentL2)->where($wcol,$ownWilayah)->countAllResults();
                if ($chk === 0) { return redirect()->to(base_url('admin/master/level3'))->with('error','Akses ditolak ke pemda TK II lain'); }
            }
        }
        $name = $row['level3'] ?? ($row['nama'] ?? ($row['name'] ?? ''));
        $level2Id = (int)($row['level2_id'] ?? 0);
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        $level2 = [];
        try {
            $qb = db_connect()->table('level2')->select('id, level2')->orderBy('level2','asc');
            // Restrict options to user's wilayah if BNNP
            $roleStr = strtolower((string)(session('role') ?? ''));
            if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
                $sessionLevel2 = (int)(session('level2') ?? 0);
                if ($sessionLevel2 > 0) {
                    $wcol = 'wilayah_id';
                    $fields = db_connect()->getFieldNames('level2');
                    foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $fields, true)) { $wcol = $c; break; } }
                    $ownRow = db_connect()->table('level2')->select($wcol.' as wilayah_id')->where('id',$sessionLevel2)->get()->getRowArray();
                    $ownWilayah = (int)($ownRow['wilayah_id'] ?? 0);
                    if ($ownWilayah > 0) { $qb->where($wcol, $ownWilayah); }
                }
            }
            $level2 = $qb->get()->getResultArray();
        } catch (\Throwable $e) { $level2 = []; }
        return view('Modules\\Admin\\Views\\master_level3_form', [
            'title' => 'Edit Pemda TK I',
            'action' => base_url('admin/master/level3/update/'.$id),
            'value' => ['name' => $name, 'level2_id' => $level2Id],
            'level2' => $level2,
            'submitLabel' => 'Update',
            'modal' => $isModal,
        ]);
    }

    public function update(int $id)
    {
        $name = trim((string)$this->request->getPost('name'));
        $level2Id = (int)($this->request->getPost('level2_id') ?? 0);
        if ($name === '') return redirect()->back()->with('error','Nama tidak boleh kosong');
        // Guard: ensure target row parent level2 lies in user's wilayah; posted level2_id must be within same wilayah
        $db = db_connect();
        $row = $db->table('level3')->where('id',$id)->get()->getRowArray();
        if (!$row) return redirect()->to(base_url('admin/master/level3'))->with('error','Data tidak ditemukan');
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $sessionLevel2 = (int)(session('level2') ?? 0);
            $wcol = 'wilayah_id';
            $fields = $db->getFieldNames('level2');
            foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $fields, true)) { $wcol = $c; break; } }
            $ownRow = $db->table('level2')->select($wcol.' as wilayah_id')->where('id',$sessionLevel2)->get()->getRowArray();
            $ownWilayah = (int)($ownRow['wilayah_id'] ?? 0);
            if ($ownWilayah > 0) {
                $parentL2 = (int)($row['level2_id'] ?? 0);
                $okParent = $db->table('level2')->select('id')->where('id',$parentL2)->where($wcol,$ownWilayah)->countAllResults() > 0;
                $okPosted = true;
                if ($level2Id !== 0) {
                    $okPosted = $db->table('level2')->select('id')->where('id',$level2Id)->where($wcol,$ownWilayah)->countAllResults() > 0;
                }
                if (!$okParent || !$okPosted) { return redirect()->back()->with('error','Tidak diperbolehkan memilih pemda TK II lain'); }
            }
        }
        $data = [$this->detectNameColumn() => $name];
        if ($level2Id > 0) { $data['level2_id'] = $level2Id; }
        try { db_connect()->table('level3')->where('id',$id)->update($data); }
        catch (\Throwable $e) { return redirect()->back()->with('error','Gagal memperbarui data'); }
        session()->setFlashdata('success','Data diperbarui');
        $redirId = $level2Id > 0 ? $level2Id : (int)($row['level2_id'] ?? 0);
        if ($this->request->isAJAX() || ((string)($this->request->getGet('modal') ?? '') === '1')) {
            return $this->response->setBody('<script>window.top.location = "'.base_url('admin/master/level3'.($redirId>0?('?id='.$redirId):'')).'";</script>');
        }
        return redirect()->to(base_url('admin/master/level3'.($redirId>0?('?id='.$redirId):'')));
    }

    public function delete(int $id)
    {
        $db = db_connect();
        // Guard: only delete within own level2
        $roleStr = strtolower((string)(session('role') ?? ''));
        if (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
            $row = $db->table('level3')->where('id',$id)->get()->getRowArray();
            if ($row) {
                $sessionLevel2 = (int)(session('level2') ?? 0);
                $wcol = 'wilayah_id';
                $fields = $db->getFieldNames('level2');
                foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $fields, true)) { $wcol = $c; break; } }
                $ownRow = $db->table('level2')->select($wcol.' as wilayah_id')->where('id',$sessionLevel2)->get()->getRowArray();
                $ownWilayah = (int)($ownRow['wilayah_id'] ?? 0);
                if ($ownWilayah > 0) {
                    $parentL2 = (int)($row['level2_id'] ?? 0);
                    $chk = $db->table('level2')->select('id')->where('id',$parentL2)->where($wcol,$ownWilayah)->countAllResults();
                    if ($chk === 0) { return redirect()->to(base_url('admin/master/level3'))->with('error','Akses ditolak ke pemda TK II lain'); }
                }
            }
        }
        try { $db->table('level3')->where('id',$id)->delete(); }
        catch (\Throwable $e) { return redirect()->to(base_url('admin/master/level3'))->with('error','Gagal menghapus data'); }
        return redirect()->to(base_url('admin/master/level3'))->with('success','Data dihapus');
    }
}
