<?php
namespace Modules\Admin\Controllers;

use App\Controllers\BaseController;

class Rencana extends BaseController
{
    public function index()
    {
        $programId = (int)($this->request->getGet('id') ?? 0);
        $db = db_connect();
        $program = null;
        try {
            $program = $db->table('program')->select('id, kode, program as nama, bidang_id')->where('id', $programId)->get()->getRowArray();
        } catch (\Throwable $e) {}

        $rows = [];
        try {
            $builder = $db->table('rencana')->select("id, kode, aksi as nama, status_pelaksana,
                (SELECT GROUP_CONCAT(indikator SEPARATOR '||') FROM indikator i WHERE i.rencana_id = rencana.id) AS indikator_list")->orderBy('kode','asc')->orderBy('id','asc');
            if ($programId > 0) { $builder->where('program_id', $programId); }
            $rows = $builder->get()->getResultArray();
        } catch (\Throwable $e) { $rows = []; }

        $no = 1;
        foreach ($rows as &$r) {
            $r['no'] = $no++;
            $r['kode'] = trim((string)($r['kode'] ?? '')) !== '' ? (string)$r['kode'] : '-';
            $r['nama'] = trim((string)($r['nama'] ?? '')) !== '' ? (string)$r['nama'] : '-';
            $sp = (int)($r['status_pelaksana'] ?? 0);
            $r['status'] = $sp===1 ? 'General' : ($sp===2 ? 'Spesifik' : '-');
            $listStr = (string)($r['indikator_list'] ?? '');
            if ($listStr !== '') {
                $items = array_filter(array_map('trim', explode('||', $listStr)), function($x){ return $x !== ''; });
                if (!empty($items)) {
                    $lis = '';
                    foreach ($items as $it) { $lis .= '<li class="list-disc ml-5">'.esc($it).'</li>'; }
                    $r['indikator'] = '<ul class="space-y-1">'.$lis.'</ul>';
                } else {
                    $r['indikator'] = '-';
                }
            } else {
                $r['indikator'] = '-';
            }
            $id = (int)($r['id'] ?? 0);
            $r['actions'] = '<div class="inline-flex items-center justify-end gap-1">'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/rencana/indikator/'.$id).'?modal=1" title="Indikator Keberhasilan" aria-label="Indikator Keberhasilan"><i data-lucide="trophy" class="w-4 h-4"></i></a>'
                .'<a class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/rencana/pelaksana/'.$id).'" title="Pelaksana" aria-label="Pelaksana"><i data-lucide="glasses" class="w-4 h-4"></i></a>'
                .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/rencana/edit/'.$id).'?pid='.$programId.'&modal=1" title="Edit" aria-label="Edit"><i data-lucide="pencil" class="w-4 h-4"></i></a>'
                .'<form method="post" action="'.base_url('admin/rencana/delete/'.$id).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'
                .csrf_field()
                .'<input type="hidden" name="program_id" value="'.(int)$programId.'" />'
                .'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600"><i data-lucide="trash-2" class="w-4 h-4"></i></button>'
                .'</form>'
                .'</div>';
        }
        unset($r);

        return view('Modules\\Admin\\Views\\rencana', [
            'title' => 'Rencana Aksi',
            'program' => $program,
            'rows' => $rows,
        ]);
    }

    public function edit(int $id)
    {
        $db = db_connect();
        $row = $db->table('rencana')->where('id',$id)->get()->getRowArray();
        if (!$row) {
            return redirect()->to(base_url('admin/rencana'))->with('error','Data tidak ditemukan');
        }
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        $pid = (int)($this->request->getGet('pid') ?? 0);
        // Resolve columns with fallbacks
        $kode = $row['kode'] ?? ($row['code'] ?? '');
        $aksi = $row['aksi'] ?? ($row['nama'] ?? ($row['rencana'] ?? ''));
        $status = isset($row['status_pelaksana']) ? (int)$row['status_pelaksana'] : (int)($row['status'] ?? 0);
        $programId = isset($row['program_id']) ? (int)$row['program_id'] : $pid;
        return view('Modules\\Admin\\Views\\rencana_form', [
            'title' => 'Edit Rencana',
            'action' => base_url('admin/rencana/update/'.$id),
            'value' => [
                'kode' => (string)$kode,
                'nama' => (string)$aksi,
                'status_pelaksana' => $status,
                'program_id' => $programId,
            ],
            'submitLabel' => 'Update',
            'modal' => $isModal,
        ]);
    }

    public function update(int $id)
    {
        $kode = trim((string)$this->request->getPost('kode'));
        $aksi = trim((string)$this->request->getPost('name'));
        $status = (int)($this->request->getPost('status_pelaksana') ?? 0);
        $programId = (int)($this->request->getPost('program_id') ?? 0);
        if ($aksi === '') {
            return redirect()->back()->with('error','Aksi tidak boleh kosong');
        }
        $data = ['aksi' => $aksi, 'status_pelaksana' => $status];
        if ($kode !== '') { $data['kode'] = $kode; }
        try {
            db_connect()->table('rencana')->where('id',$id)->update($data);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error','Gagal memperbarui data');
        }
        $redir = base_url('admin/rencana') . ($programId>0 ? ('?id='.$programId) : '');
        return redirect()->to($redir)->with('success','Rencana diperbarui');
    }

    public function delete(int $id)
    {
        $programId = (int)($this->request->getPost('program_id') ?? 0);
        try {
            db_connect()->table('rencana')->where('id',$id)->delete();
        } catch (\Throwable $e) {
            $redirErr = base_url('admin/rencana') . ($programId>0 ? ('?id='.$programId) : '');
            return redirect()->to($redirErr)->with('error','Gagal menghapus data');
        }
        $redir = base_url('admin/rencana') . ($programId>0 ? ('?id='.$programId) : '');
        return redirect()->to($redir)->with('success','Rencana dihapus');
    }

    public function indikator(int $rencanaId)
    {
        $db = db_connect();
        $rencana = $db->table('rencana')->select('id, kode, aksi as nama')->where('id',$rencanaId)->get()->getRowArray();
        if (!$rencana) {
            return '<div class="p-3 text-sm text-rose-700">Data tidak ditemukan</div>';
        }
        $items = [];
        try {
            $items = $db->table('indikator')->select('id, indikator')->where('rencana_id',$rencanaId)->orderBy('id','asc')->get()->getResultArray();
        } catch (\Throwable $e) { $items = []; }
        return view('Modules\\Admin\\Views\\rencana_indikator', [
            'rencana' => $rencana,
            'items' => $items,
        ]);
    }

    public function indikatorStore()
    {
        $rencanaId = (int)($this->request->getPost('rencana_id') ?? 0);
        $text = trim((string)$this->request->getPost('indikator'));
        if ($rencanaId<=0 || $text==='') {
            return redirect()->back()->with('error','Indikator tidak boleh kosong');
        }
        try { db_connect()->table('indikator')->insert(['rencana_id'=>$rencanaId, 'indikator'=>$text]); }
        catch (\Throwable $e) { return redirect()->back()->with('error','Gagal menyimpan indikator'); }
        if ($this->request->isAJAX() || (string)($this->request->getGet('modal') ?? '') === '1') {
            return $this->response->setStatusCode(200)->setBody('OK');
        }
        return redirect()->to(base_url('admin/rencana/indikator/'.$rencanaId).'?modal=1');
    }

    public function indikatorDelete(int $id)
    {
        $db = db_connect();
        $rencanaId = 0;
        try {
            $row = $db->table('indikator')->select('rencana_id')->where('id',$id)->get()->getRowArray();
            $rencanaId = (int)($row['rencana_id'] ?? 0);
            $db->table('indikator')->where('id',$id)->delete();
        } catch (\Throwable $e) {}
        if ($this->request->isAJAX() || (string)($this->request->getGet('modal') ?? '') === '1') {
            return $this->response->setStatusCode(200)->setBody('OK');
        }
        return redirect()->to(base_url('admin/rencana/indikator/'.$rencanaId).'?modal=1');
    }

    public function pelaksana(int $rencanaId)
    {
        $db = db_connect();
        $rencana = $db->table('rencana')->select('id, kode, aksi as nama, program_id')->where('id',$rencanaId)->get()->getRowArray();
        if (!$rencana) {
            return '<div class="p-3 text-sm text-rose-700">Data tidak ditemukan</div>';
        }
        $items = [];
        try {
            $items = $db->table('pelaksana p')
                ->select('p.id, p.level1_id, p.level2_id, p.level3_id, l1.level1 as level1_name, l2.level2 as level2_name, l3.level3 as level3_name')
                ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                ->join('level2 l2', 'l2.id = p.level2_id', 'left')
                ->join('level3 l3', 'l3.id = p.level3_id', 'left')
                ->where('p.rencana_id',$rencanaId)
                ->orderBy('p.id','asc')
                ->get()->getResultArray();
        } catch (\Throwable $e) { $items = []; }
        $isModal = (string)($this->request->getGet('modal') ?? '') === '1' || $this->request->isAJAX();
        $payload = [ 'rencana' => $rencana, 'items' => $items ];
        if ($isModal) {
            return view('Modules\\Admin\\Views\\rencana_pelaksana', $payload);
        }
        // Build rows for data-table
        $rows = [];
        $no = 1;
        foreach ($items as $it) {
            $rid = (int)($it['id'] ?? 0);
            $rows[] = [
                'no' => $no++,
                'level1' => (string)($it['level1_name'] ?? ($it['level1_id'] ?? '-')),
                'level2' => (string)($it['level2_name'] ?? ($it['level2_id'] ?? '-')),
                'level3' => (string)($it['level3_name'] ?? ($it['level3_id'] ?? '-')),
                'actions' => '<div class="inline-flex items-center justify-end gap-1">'
                    .'<form method="post" action="'.base_url('admin/rencana/pelaksana/delete/'.$rid).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'
                    .csrf_field()
                    .'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600"><i data-lucide="trash-2" class="w-4 h-4"></i></button>'
                    .'</form>'
                    .'</div>',
            ];
        }
        return view('Modules\\Admin\\Views\\rencana_pelaksana_page', [
            'rencana' => $rencana,
            'rows' => $rows,
        ]);
    }

    public function pelaksanaStore()
    {
        $rencanaId = (int)($this->request->getPost('rencana_id') ?? 0);
        $l1 = (int)($this->request->getPost('level1_id') ?? 0);
        $l2 = $this->request->getPost('level2_id');
        $l3 = $this->request->getPost('level3_id');
        $data = ['rencana_id'=>$rencanaId, 'level1_id'=>$l1];
        if ($l2 !== null && $l2 !== '') { $data['level2_id'] = (int)$l2; }
        if ($l3 !== null && $l3 !== '') { $data['level3_id'] = (int)$l3; }
        if ($rencanaId<=0 || $l1<=0) {
            return redirect()->back()->with('error','Level1 dan Rencana wajib diisi');
        }
        try { db_connect()->table('pelaksana')->insert($data); }
        catch (\Throwable $e) { return redirect()->back()->with('error','Gagal menyimpan pelaksana'); }
        if ($this->request->isAJAX() || (string)($this->request->getGet('modal') ?? '') === '1') {
            return $this->response->setStatusCode(200)->setBody('OK');
        }
        return redirect()->to(base_url('admin/rencana/pelaksana/'.$rencanaId).'?modal=1');
    }

    public function pelaksanaDelete(int $id)
    {
        $db = db_connect();
        $rencanaId = 0;
        try {
            $row = $db->table('pelaksana')->select('rencana_id')->where('id',$id)->get()->getRowArray();
            $rencanaId = (int)($row['rencana_id'] ?? 0);
            $db->table('pelaksana')->where('id',$id)->delete();
        } catch (\Throwable $e) {}
        if ($this->request->isAJAX() || (string)($this->request->getGet('modal') ?? '') === '1') {
            return $this->response->setStatusCode(200)->setBody('OK');
        }
        return redirect()->to(base_url('admin/rencana/pelaksana/'.$rencanaId).'?modal=1');
    }

    public function pelaksanaForm()
    {
        $rencanaId = (int)($this->request->getGet('rencana_id') ?? 0);
        if ($rencanaId <= 0) {
            return '<div class="p-3 text-sm text-rose-700">Parameter tidak valid</div>';
        }
        $level1 = [];
        try { $level1 = db_connect()->table('level1')->select('id, level1')->orderBy('level1','asc')->get()->getResultArray(); } catch (\Throwable $e) { $level1 = []; }
        return view('Modules\\Admin\\Views\\rencana_pelaksana_form', [
            'rencana_id' => $rencanaId,
            'level1' => $level1,
        ]);
    }

    public function pelaksanaAutoGeneral(int $rencanaId)
    {
        $db = db_connect();
        if ($rencanaId <= 0) {
            return redirect()->back()->with('error','Parameter tidak valid');
        }
        try {
            // Fetch all Level1 entries and insert pelaksana for each if not exists
            $level1s = $db->table('level1')->select('id')->orderBy('id','asc')->get()->getResultArray();
            foreach ($level1s as $l1) {
                $lid = (int)($l1['id'] ?? 0);
                if ($lid <= 0) continue;
                // skip duplicate
                $exists = $db->table('pelaksana')->where(['rencana_id'=>$rencanaId,'level1_id'=>$lid])->countAllResults();
                if ($exists > 0) continue;
                $db->table('pelaksana')->insert(['rencana_id'=>$rencanaId,'level1_id'=>$lid]);
            }
        } catch (\Throwable $e) {
            if ($this->request->isAJAX()) { return $this->response->setStatusCode(500)->setBody('ERR'); }
            return redirect()->back()->with('error','Gagal menjalankan Auto General');
        }
        if ($this->request->isAJAX()) { return $this->response->setStatusCode(200)->setBody('OK'); }
        return redirect()->to(base_url('admin/rencana/pelaksana/'.$rencanaId));
    }

    public function pelaksanaOptionsLevel2()
    {
        $level1Id = (int)($this->request->getGet('level1_id') ?? 0);
        $rows = [];
        if ($level1Id > 0) {
            try {
                $db = db_connect();
                $qb = $db->table('level2')->select('id, level2')->where('level1_id',$level1Id)->orderBy('level2','asc');
                // Role-based scoping
                $roleStr = strtolower((string)(session('role') ?? ''));
                if (strpos($roleStr, 'kab/kota') !== false) {
                    $sessL2 = (int)(session('level2') ?? 0);
                    if ($sessL2 > 0) { $qb->where('id', $sessL2); }
                } elseif (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
                    // restrict to own wilayah derived from session level2
                    $sessL2 = (int)(session('level2') ?? 0);
                    if ($sessL2 > 0) {
                        $wcol = 'wilayah_id';
                        try { $l2Fields = $db->getFieldNames('level2'); foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $l2Fields, true)) { $wcol = $c; break; } } } catch (\Throwable $e) {}
                        $own = $db->table('level2')->select($wcol.' as wilayah_id')->where('id',$sessL2)->get()->getRowArray();
                        $ownWil = (int)($own['wilayah_id'] ?? 0);
                        if ($ownWil > 0) { $qb->where($wcol, $ownWil); }
                    }
                }
                $rows = $qb->get()->getResultArray();
            } catch (\Throwable $e) { $rows = []; }
        }
        return $this->response->setJSON(['items' => $rows]);
    }

    public function pelaksanaOptionsLevel3()
    {
        $level2Id = (int)($this->request->getGet('level2_id') ?? 0);
        $rows = [];
        if ($level2Id > 0) {
            try {
                $db = db_connect();
                // Role-based scoping
                $ok = true;
                $roleStr = strtolower((string)(session('role') ?? ''));
                if (strpos($roleStr, 'kab/kota') !== false) {
                    $sessL2 = (int)(session('level2') ?? 0);
                    if ($sessL2 > 0 && $level2Id !== $sessL2) { $ok = false; }
                } elseif (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false) {
                    $sessL2 = (int)(session('level2') ?? 0);
                    if ($sessL2 > 0) {
                        $wcol = 'wilayah_id';
                        try { $l2Fields = $db->getFieldNames('level2'); foreach (['wilayah_id','wilayah','id_wilayah'] as $c) { if (in_array($c, $l2Fields, true)) { $wcol = $c; break; } } } catch (\Throwable $e) {}
                        $own = $db->table('level2')->select($wcol.' as wilayah_id')->where('id',$sessL2)->get()->getRowArray();
                        $ownWil = (int)($own['wilayah_id'] ?? 0);
                        if ($ownWil > 0) {
                            $chk = $db->table('level2')->select('id')->where('id',$level2Id)->where($wcol,$ownWil)->countAllResults();
                            $ok = $chk > 0;
                        }
                    }
                }
                if ($ok) {
                    $rows = $db->table('level3')->select('id, level3')->where('level2_id',$level2Id)->orderBy('level3','asc')->get()->getResultArray();
                } else {
                    $rows = [];
                }
            } catch (\Throwable $e) { $rows = []; }
        }
        return $this->response->setJSON(['items' => $rows]);
    }
}
