<?php $isModal = (bool)($modal ?? false); ?>
<?php if (!$isModal): ?>
<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Form Bidang',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Peraturan Presiden']
]) ?>
  <div class="mb-6">
    <h1 class="text-2xl font-bold"><?= esc($title ?? 'Form Bidang') ?></h1>
  </div>
  <section class="pb-6">
<?php endif; ?>

  <?php if (session()->getFlashdata('error')): ?>
    <div class="mb-4 p-3 rounded bg-rose-50 text-rose-700 border border-rose-200">
      <?= esc(session()->getFlashdata('error')) ?>
    </div>
  <?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <form method="post" action="<?= esc($action ?? '') ?>" class="grid grid-cols-1 gap-4">
      <?= csrf_field() ?>
      <div>
        <label class="block text-sm text-slate-600 mb-1">Kode</label>
        <input name="kode" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string) (($value['kode'] ?? '') )) ?>" />
      </div>
      <div>
        <label class="block text-sm text-slate-600 mb-1">Nama Bidang</label>
        <input name="name" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string) (($value['nama'] ?? ($value ?? '')) )) ?>" required />
      </div>
      <div class="flex justify-end gap-2 mt-4">
        <?php if (!$isModal): ?>
          <a href="<?= base_url('admin/bidang') ?>" class="px-4 py-2 rounded-lg border">Batal</a>
        <?php endif; ?>
        <button type="submit" class="px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700"><?= esc($submitLabel ?? 'Simpan') ?></button>
      </div>
    </form>
  </div>

<?php if (!$isModal): ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
<?php endif; ?>
