<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Wilayah - Pemda TK II',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Wilayah','Pemda TK II']
]) ?>

  <div class="mb-6 flex items-center justify-between">
    <div>
      <h1 class="text-2xl font-bold">Wilayah - Pemda TK II</h1>
      <p class="text-slate-500">Daftar Pemda Tingkat II</p>
    </div>
  </div>

  <section class="pb-6">
    <?php
      $rows = array_values($rows ?? []);
      $rows = array_map(function($r) use (&$i){
        static $n = 0; $n++;
        $id = (int)($r['id'] ?? 0);
        $actions = '<div class="inline-flex items-center justify-end gap-1">'
          .'<a class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/level3?id='.$id).'" title="Detail" aria-label="Detail"><i data-lucide="eye" class="w-4 h-4"></i></a>'
          .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/level2/edit/'.$id).'" title="Edit" aria-label="Edit"><i data-lucide="pencil" class="w-4 h-4"></i></a>'
          .'<form method="post" action="'.base_url('admin/master/level2/delete/'.$id).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'.csrf_field().'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600"><i data-lucide="trash-2" class="w-4 h-4"></i></button></form>'
          .'</div>';
        return [
          'no' => $n,
          'name' => (string)($r['name'] ?? '-'),
          'actions' => $actions,
        ];
      }, $rows);
      echo view('components/data-table', [
        'id' => 'dt_level2',
        'headers' => [
          ['key' => 'no', 'label' => 'No'],
          ['key' => 'name', 'label' => 'Nama Pemda TK II'],
          ['key' => 'actions', 'label' => 'Aksi', 'raw' => true],
        ],
        'rows' => $rows,
        'pageSize' => 10,
      ]);
    ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
