<?php $isModal = (bool)($modal ?? false); ?>
<?php if (!$isModal): ?>
<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Detail Pemda TK II',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Wilayah','Pemda TK II']
]) ?>
  <div class="mb-6">
    <h1 class="text-2xl font-bold"><?= esc($title ?? 'Detail Pemda TK II') ?></h1>
  </div>
  <section class="pb-6">
<?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
      <div>
        <div class="text-slate-500">ID</div>
        <div class="font-medium text-slate-800"><?= esc((string)($row['id'] ?? '')) ?></div>
      </div>
      <div>
        <div class="text-slate-500">Nama Pemda TK II</div>
        <div class="font-medium text-slate-800"><?= esc((string)($row['level2'] ?? ($row['nama'] ?? ($row['name'] ?? '')))) ?></div>
      </div>
      <div class="md:col-span-2">
        <div class="text-slate-500">Wilayah ID</div>
        <div class="font-medium text-slate-800"><?= esc((string)($row['wilayah_id'] ?? '-')) ?></div>
      </div>
    </div>
    <?php if (!$isModal): ?>
      <div class="mt-6">
        <a href="<?= base_url('admin/master/level2') ?>" class="px-4 py-2 rounded-lg border">Kembali</a>
      </div>
    <?php endif; ?>
  </div>

<?php if (!$isModal): ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
<?php endif; ?>
