<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Wilayah - Pemda TK I',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Wilayah','Pemda TK I']
]) ?>

  <div class="mb-6 flex items-center justify-between">
    <div>
      <h1 class="text-2xl font-bold">Wilayah - Pemda TK I</h1>
      <p class="text-slate-500">Daftar Pemda Tingkat I</p>
    </div>
    <?php $curId = (int)(service('request')->getGet('id') ?? 0); ?>
    <a data-modal href="<?= base_url('admin/master/level3/create'.($curId>0?('?id='.$curId):'')) ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50 text-sm">
      <i data-lucide="plus" class="w-4 h-4"></i>
      <span>Tambah</span>
    </a>
  </div>

  <section class="pb-6">
    <?php
      $rows = array_values($rows ?? []);
      $rows = array_map(function($r){
        static $n = 0; $n++;
        $id = (int)($r['id'] ?? 0);
        $actions = '<div class="inline-flex items-center justify-end gap-1">'
          .'<a data-modal class="p-1 rounded border bg-white hover:bg-slate-50" href="'.base_url('admin/master/level3/edit/'.$id).'" title="Edit" aria-label="Edit"><i data-lucide="pencil" class="w-4 h-4"></i></a>'
          .'<form method="post" action="'.base_url('admin/master/level3/delete/'.$id).'" data-confirm="Yakin hapus data ini?" class="inline" title="Delete" aria-label="Delete">'.csrf_field().'<button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600"><i data-lucide="trash-2" class="w-4 h-4"></i></button></form>'
          .'</div>';
        return [
          'no' => $n,
          'name' => (string)($r['name'] ?? '-'),
          'actions' => $actions,
        ];
      }, $rows);
      echo view('components/data-table', [
        'id' => 'dt_level3',
        'headers' => [
          ['key' => 'no', 'label' => 'No'],
          ['key' => 'name', 'label' => 'Level3'],
          ['key' => 'actions', 'label' => 'Aksi', 'raw' => true],
        ],
        'rows' => $rows,
        'pageSize' => 10,
      ]);
    ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
