<?php $isModal = (bool)($modal ?? false); ?>
<?php if (!$isModal): ?>
<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Form Pemda TK I',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Wilayah','Pemda TK I']
]) ?>
  <div class="mb-6">
    <h1 class="text-2xl font-bold"><?= esc($title ?? 'Form Pemda TK I') ?></h1>
  </div>
  <section class="pb-6">
<?php endif; ?>

  <?php if (session()->getFlashdata('error')): ?>
    <div class="mb-4 p-3 rounded bg-rose-50 text-rose-700 border border-rose-200">
      <?= esc(session()->getFlashdata('error')) ?>
    </div>
  <?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <form method="post" action="<?= esc($action ?? '') ?>" class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <?= csrf_field() ?>
      <div>
        <label class="block text-sm text-slate-600 mb-1">Nama Pemda TK I</label>
        <input name="name" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string) (($value['name'] ?? ''))) ?>" required />
      </div>
      <?php
        $roleStr = strtolower((string)(session('role') ?? ''));
        $isBnnp = (strpos($roleStr, 'provinsi') !== false || strpos($roleStr, 'bnnp') !== false);
        // Determine selected level2 id
        $selL2 = (int)($value['level2_id'] ?? 0);
        if ($selL2 === 0 && !empty($level2)) {
          $first = $level2[0] ?? [];
          $selL2 = (int)($first['id'] ?? 0);
        }
      ?>
      <?php if ($isBnnp): ?>
        <input type="hidden" name="level2_id" value="<?= (int)$selL2 ?>" />
      <?php else: ?>
        <div>
          <label class="block text-sm text-slate-600 mb-1">Pemda TK II (Parent)</label>
          <select name="level2_id" class="w-full border rounded-lg px-3 py-2">
            <option value="">Pilih</option>
            <?php foreach (($level2 ?? []) as $p): $pid=(int)($p['id']??0); ?>
              <option value="<?= $pid ?>" <?= ($selL2 === $pid ? 'selected' : '') ?>><?= esc($p['level2'] ?? '-') ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      <?php endif; ?>
      <div class="md:col-span-2 flex justify-end gap-2 mt-4">
        <?php if (!$isModal): ?>
          <a href="<?= base_url('admin/master/level3') ?>" class="px-4 py-2 rounded-lg border">Batal</a>
        <?php endif; ?>
        <button type="submit" class="px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700"><?= esc($submitLabel ?? 'Simpan') ?></button>
      </div>
    </form>
  </div>

<?php if (!$isModal): ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
<?php endif; ?>
