<?php $isModal = (bool)($modal ?? false); ?>
<?php if (!$isModal): ?>
<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Detail Pemda TK I',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Wilayah','Pemda TK I']
]) ?>
  <div class="mb-6">
    <h1 class="text-2xl font-bold"><?= esc($title ?? 'Detail Pemda TK I') ?></h1>
  </div>
  <section class="pb-6">
<?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
      <div>
        <div class="text-slate-500">ID</div>
        <div class="font-medium text-slate-800"><?= esc((string)($row['id'] ?? '')) ?></div>
      </div>
      <div>
        <div class="text-slate-500">Nama Pemda TK I</div>
        <div class="font-medium text-slate-800"><?= esc((string)($row['level3'] ?? ($row['nama'] ?? ($row['name'] ?? '')))) ?></div>
      </div>
      <div class="md:col-span-2">
        <div class="text-slate-500">Pemda TK II (Parent)</div>
        <div class="font-medium text-slate-800"><?= esc((string)($row['level2_id'] ?? '-')) ?></div>
      </div>
    </div>
    <?php if (!$isModal): ?>
      <div class="mt-6">
        <a href="<?= base_url('admin/master/level3') ?>" class="px-4 py-2 rounded-lg border">Kembali</a>
      </div>
    <?php endif; ?>
  </div>

<?php if (!$isModal): ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
<?php endif; ?>
