<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Program',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Program']
]) ?>

  <div class="mb-6 flex items-center justify-between">
    <div>
      <h1 class="text-2xl font-bold">Program</h1>
    </div>
    <a href="<?= base_url('admin/bidang') ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50 text-sm">
      <i data-lucide="arrow-left" class="w-4 h-4"></i>
      <span>Kembali</span>
    </a>
  </div>

  <section class="pb-6">
    <?php
      echo view('components/data-table', [
        'id' => 'dt_program',
        'headers' => [
          ['key' => 'no', 'label' => 'No', 'noSort' => true],
          ['key' => 'kode', 'label' => 'Kode'],
          ['key' => 'nama', 'label' => 'Nama Program'],
          ['key' => 'actions', 'label' => 'Aksi', 'raw' => true],
        ],
        'rows' => array_values($rows ?? []),
        'pageSize' => 10,
      ]);
    ?>
  </section>

<?= view('layouts/dashboard_footer') ?>
