<?php $isModal = (bool)($modal ?? false); ?>
<?php if (!$isModal): ?>
<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Form Rencana',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Rencana']
]) ?>
  <div class="mb-6">
    <h1 class="text-2xl font-bold"><?= esc($title ?? 'Form Rencana') ?></h1>
  </div>
  <section class="pb-6">
<?php endif; ?>

  <?php if (session()->getFlashdata('error')): ?>
    <div class="mb-4 p-3 rounded bg-rose-50 text-rose-700 border border-rose-200">
      <?= esc(session()->getFlashdata('error')) ?>
    </div>
  <?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <form method="post" action="<?= esc($action ?? '') ?>" class="grid grid-cols-1 gap-4">
      <?= csrf_field() ?>
      <input type="hidden" name="program_id" value="<?= esc((string)($value['program_id'] ?? '0')) ?>" />
      <div>
        <label class="block text-sm text-slate-600 mb-1">Kode</label>
        <input name="kode" type="text" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string)($value['kode'] ?? '')) ?>" />
      </div>
      <div>
        <label class="block text-sm text-slate-600 mb-1">Status Pelaksana</label>
        <select name="status_pelaksana" class="w-full border rounded-lg px-3 py-2">
          <option value="">Pilih</option>
          <option value="1" <?= ((int)($value['status_pelaksana'] ?? 0) === 1 ? 'selected' : '') ?>>General</option>
          <option value="2" <?= ((int)($value['status_pelaksana'] ?? 0) === 2 ? 'selected' : '') ?>>Spesifik</option>
        </select>
      </div>
      <div>
        <label class="block text-sm text-slate-600 mb-1">Aksi</label>
        <textarea name="name" rows="4" class="w-full border rounded-lg px-3 py-2" required><?= esc((string)($value['nama'] ?? '')) ?></textarea>
      </div>
      <div class="flex justify-end gap-2 mt-4">
        <?php if (!$isModal): ?>
          <a href="<?= base_url('admin/rencana' . (((int)($value['program_id'] ?? 0)) > 0 ? ('?id=' . (int)($value['program_id'] ?? 0)) : '')) ?>" class="px-4 py-2 rounded-lg border">Batal</a>
        <?php endif; ?>
        <button type="submit" class="px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700"><?= esc($submitLabel ?? 'Simpan') ?></button>
      </div>
    </form>
  </div>

<?php if (!$isModal): ?>
  </section>
<?= view('layouts/dashboard_footer') ?>
<?php endif; ?>
