<?php
// Modal body for managing Pelaksana of a Rencana
?>
<div class="space-y-4">
  <div>
    <div class="text-sm font-semibold text-slate-700">Pelaksana</div>
    <div class="text-xs text-slate-500">Rencana: <?= esc((string)($rencana['kode'] ?? '')) ?> - <?= esc((string)($rencana['nama'] ?? '')) ?></div>
  </div>

  <form method="post" action="<?= base_url('admin/rencana/pelaksana/store') ?>" class="grid grid-cols-1 sm:grid-cols-3 gap-3">
    <?= csrf_field() ?>
    <input type="hidden" name="rencana_id" value="<?= (int)($rencana['id'] ?? 0) ?>" />
    <div>
      <label class="block text-sm text-slate-600 mb-1">Level 1 (wajib)</label>
      <input type="number" name="level1_id" class="w-full border rounded-lg px-3 py-2" placeholder="ID Level 1" required />
    </div>
    <div>
      <label class="block text-sm text-slate-600 mb-1">Level 2</label>
      <input type="number" name="level2_id" class="w-full border rounded-lg px-3 py-2" placeholder="ID Level 2 (opsional)" />
    </div>
    <div>
      <label class="block text-sm text-slate-600 mb-1">Level 3</label>
      <input type="number" name="level3_id" class="w-full border rounded-lg px-3 py-2" placeholder="ID Level 3 (opsional)" />
    </div>
    <div class="sm:col-span-3 flex justify-end">
      <button type="submit" class="px-3 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">Tambah Pelaksana</button>
    </div>
  </form>

  <div class="border-t pt-3">
    <div class="text-sm font-semibold text-slate-700 mb-2">Daftar Pelaksana</div>
    <div class="overflow-x-auto">
      <table class="min-w-full divide-y divide-slate-200 text-sm">
        <thead class="bg-slate-50">
          <tr>
            <th class="px-3 py-2 text-left text-slate-600">No</th>
            <th class="px-3 py-2 text-left text-slate-600">Level 1</th>
            <th class="px-3 py-2 text-left text-slate-600">Level 2</th>
            <th class="px-3 py-2 text-left text-slate-600">Level 3</th>
            <th class="px-3 py-2 text-right text-slate-600">Aksi</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-slate-100 bg-white">
          <?php $no=1; foreach (($items ?? []) as $it): ?>
            <tr>
              <td class="px-3 py-2 text-slate-700"><?= $no++ ?></td>
              <td class="px-3 py-2 text-slate-700 break-words"><?= esc((string)($it['level1_id'] ?? '')) ?></td>
              <td class="px-3 py-2 text-slate-700 break-words"><?= esc((string)($it['level2_id'] ?? '')) ?></td>
              <td class="px-3 py-2 text-slate-700 break-words"><?= esc((string)($it['level3_id'] ?? '')) ?></td>
              <td class="px-3 py-2 text-right">
                <form method="post" action="<?= base_url('admin/rencana/pelaksana/delete/'.(int)($it['id'] ?? 0)) ?>" data-confirm="Yakin hapus pelaksana ini?" class="inline">
                  <?= csrf_field() ?>
                  <button type="submit" class="p-1 rounded border bg-white hover:bg-rose-50 text-rose-600" title="Hapus" aria-label="Hapus">
                    <i data-lucide="trash-2" class="w-4 h-4"></i>
                  </button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (empty($items)): ?>
            <tr>
              <td colspan="5" class="px-3 py-4 text-center text-slate-500">Belum ada pelaksana</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
