<?= view('layouts/dashboard_header', [
  'title' => 'Pelaksana',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Rencana','Pelaksana']
]) ?>

  <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-start sm:justify-between">
    <div class="shrink min-w-0">
      <h1 class="text-2xl font-bold">Pelaksana</h1>
      <p class="text-slate-500">Rencana: <?= esc((string)($rencana['kode'] ?? '')) ?> - <?= esc((string)($rencana['nama'] ?? '')) ?></p>
    </div>
    <?php $pid = (int)($rencana['program_id'] ?? 0); ?>
    <div class="flex flex-wrap items-center gap-2">
      <a data-modal href="<?= base_url('admin/rencana/pelaksana/form?rencana_id='.(int)($rencana['id'] ?? 0).'&modal=1') ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50 text-sm">
        <i data-lucide="plus" class="w-4 h-4"></i>
        <span>Tambah Spesifik</span>
      </a>
      <form method="post" action="<?= base_url('admin/rencana/pelaksana/auto_general/'.(int)($rencana['id'] ?? 0)) ?>" data-confirm="Yakin jalankan Auto General?">
        <?= csrf_field() ?>
        <button type="submit" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50 text-sm" title="Auto General">
          <i data-lucide="wand" class="w-4 h-4"></i>
          <span>Auto General</span>
        </button>
      </form>
      <a href="<?= base_url('admin/rencana'.($pid>0?('?id='.$pid):'')) ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border bg-white hover:bg-slate-50 text-sm">
        <i data-lucide="arrow-left" class="w-4 h-4"></i>
        <span>Kembali</span>
      </a>
    </div>
  </div>

  <section class="pb-6">
    <div class="bg-white rounded-2xl shadow p-4">
      <?php
        echo view('components/data-table', [
          'id' => 'dt_pelaksana',
          'headers' => [
            ['key' => 'no', 'label' => 'No', 'noSort' => true],
            ['key' => 'level1', 'label' => 'Level 1'],
            ['key' => 'level2', 'label' => 'Level 2'],
            ['key' => 'level3', 'label' => 'Level 3'],
            ['key' => 'actions', 'label' => 'Aksi', 'raw' => true],
          ],
          'rows' => array_values($rows ?? []),
          'pageSize' => 10,
        ]);
      ?>
    </div>
  </section>

<?= view('layouts/dashboard_footer') ?>
