<?php
namespace Modules\Auth\Controllers;

use App\Controllers\BaseController;
use App\Models\UserAuthModel;

class Auth extends BaseController
{
    protected $userModel;

    public function __construct()
    {
        $this->userModel = new UserAuthModel();
        helper(['url', 'form']);
        session();
    }

    public function login()
    {
        if (session('logged_in')) {
            return $this->redirectByRole(session('role') ?? '');
        }
        return view('auth/login');
    }

    public function attempt()
    {
        $username = trim($this->request->getPost('username'));
        $password = (string) $this->request->getPost('password');

        if ($username === '' || $password === '') {
            return redirect()->back()->with('error', 'Username dan password wajib diisi');
        }

        $user = $this->userModel->findByUsername($username);
        if (!$user) {
            return redirect()->back()->with('error', 'Akun tidak ditemukan');
        }

        // Expect password hashed in DB
        if (!password_verify($password, $user['password'])) {
            return redirect()->back()->with('error', 'Password salah');
        }

        $role = (string) ($user['role'] ?? 'user');
        $roleHead = strtolower(explode(' ', $role)[0] ?? 'user');

        $sessionData = [
            'id'        => $user['id'] ?? null,
            'nama'      => $user['nama'] ?? null,
            'username'  => $user['username'] ?? $username,
            'level1'    => $user['level1_id'] ?? null,
            'level2'    => $user['level2_id'] ?? null,
            'level3'    => $user['level3_id'] ?? null,
            'role_id'   => $user['role_id'] ?? null,
            'role'      => $role,
            'email'     => $user['email'] ?? null,
            'group_wilayah' => $user['group_wilayah_id'] ?? null,
            'wilayah'   => $user['wilayah_id'] ?? null,
            'logged_in' => true,
        ];
        session()->set($sessionData);

        return $this->redirectByRole($roleHead);
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to(base_url('login'));
    }

    private function redirectByRole(string $roleStr)
    {
        $role = strtolower(trim($roleStr));
        if ($role === '') {
            return redirect()->to(base_url('user'));
        }
        if (strpos($role, 'admin') !== false) {
            return redirect()->to(base_url('admin'));
        }
        if (strpos($role, 'evaluator') !== false) {
            return redirect()->to(base_url('evaluator'));
        }
        if (strpos($role, 'eksekutif') !== false) {
            return redirect()->to(base_url('eksekutif'));
        }
        return redirect()->to(base_url('user'));
    }
}
