<?php
namespace Modules\Eksekutif\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;

class Laporan extends BaseController
{
    public function index()
    {
        helper(['laporan','url']);
        // Mirror Admin/Periode index: build Pemda-approved counts per tahun
        $rows = [];
        $years = [];
        $yearRows = [];
        $map = [];
        try {
            $db = db_connect();
            $rowsPemda = $db->table('keberhasilan k')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                ->select('k.tahun as tahun', false)
                ->select('COUNT(*) as jumlah', false)
                ->groupStart()->where('k.status_eval', 2)->orWhere('k.status', '2')->groupEnd()
                ->where('l1.id', 6)
                ->where('k.tahun IS NOT NULL', null, false)
                ->where('k.tahun <> ""', null, false)
                ->groupBy('k.tahun')
                ->orderBy('tahun', 'DESC')
                ->get()->getResultArray();
            foreach ($rowsPemda as $r) {
                $ty = isset($r['tahun']) ? (int)$r['tahun'] : 0;
                if ($ty > 0) { $map[$ty] = (int)($r['jumlah'] ?? 0); }
            }
        } catch (\Throwable $e) { $map = []; }
        if ($map) {
            krsort($map);
            foreach ($map as $y => $cnt) { $yearRows[] = [ 'tahun' => (int)$y, 'jumlah' => (int)$cnt ]; }
        } else {
            $y = (int) date('Y');
            for ($i=0; $i<5; $i++) { $yearRows[] = ['tahun' => $y-$i, 'jumlah' => 0]; }
        }

        // Optional filters like Admin page (kept empty initially)
        $rencanaSel = (int)($this->request->getGet('rencana') ?? 0);
        $pelaksanaSel = (int)($this->request->getGet('pelaksana') ?? 0);
        $indikatorSel = (int)($this->request->getGet('indikator') ?? 0);
        if ($rencanaSel && $pelaksanaSel && $indikatorSel) {
            try {
                $model = new \App\Models\CapaianOutputModel();
                $perList = listPeriode();
                foreach ($perList as $p) {
                    [$th, $bl] = explode('_', $p) + [0=>0,1=>0];
                    $th = (int)$th; $bl = (int)$bl;
                    $dataM = $model->getCapaian($rencanaSel, $th, $bl, $pelaksanaSel, $indikatorSel);
                    $merged = mergeCapaian($dataM);
                    $total = 0; foreach ($merged as $m) { $total += (int)($m['total_output'] ?? 0); }
                    $rows[] = [ 'periode'=>$p, 'tahun'=>$th, 'bulan'=>$bl, 'total_output'=>$total ];
                }
            } catch (\Throwable $e) { $rows = []; }
        }

        return view('admin/laporan/periode', [
            'title' => 'Laporan',
            'breadcrumb' => ['Eksekutif','Laporan'],
            'rencanaSel' => $rencanaSel,
            'pelaksanaSel' => $pelaksanaSel,
            'indikatorSel' => $indikatorSel,
            'rows' => $rows,
            'years' => $years,
            'yearRows' => $yearRows,
            'basePrefix' => 'eksekutif',
        ]);
    }

    public function rencana()
    {
        helper(['url']);
        $tahun = (int) ($this->request->getGet('tahun') ?? 0);
        $history = (string) ($this->request->getGet('status') ?? '') === 'true';
        $isDebug = in_array(strtolower((string)($this->request->getGet('debug') ?? '')), ['1','true','yes'], true);
        if ($tahun <= 0) {
            return redirect()->to(base_url('eksekutif/laporan'));
        }
        $rows = [];
        try {
            $db = db_connect();
            $b = $db->table('keberhasilan k')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                ->select('r.id as rencana_id, r.kode, r.aksi, COUNT(*) as jumlah', false)
                ->where('k.tahun', $tahun)
                ->where('l1.id', 6)
                ->groupBy('r.id, r.kode, r.aksi')
                ->orderBy('jumlah', 'DESC');
            if ($history) {
                $b->groupStart()->where('k.status_eval', 2)->orWhere('k.status', '2')->groupEnd();
            } else {
                $b->groupStart()->where('k.status_eval', 2)->orWhere('k.status', '2')->groupEnd();
            }
            if ($isDebug) {
                $compiled = $b->getCompiledSelect();
                $result = $db->query($compiled)->getResultArray();
                return $this->response->setJSON([
                    'tahun' => $tahun,
                    'history' => $history,
                    'compiled_sql' => $compiled,
                    'row_count' => is_array($result) ? count($result) : 0,
                    'sample_first' => $result[0] ?? null,
                ]);
            }
            $rows = $b->get()->getResultArray();
        } catch (\Throwable $e) {
            $rows = [];
        }
        return view('admin/laporan/rencana', [
            'title' => 'Laporan - Rencana',
            'breadcrumb' => ['Eksekutif','Laporan','Rencana'],
            'tahun' => $tahun,
            'rows' => $rows,
            'basePrefix' => 'eksekutif',
        ]);
    }

    public function detail()
    {
        helper(['url']);
        $tahun = (int) ($this->request->getGet('tahun') ?? 0);
        $rencanaId = (int) ($this->request->getGet('rencana_id') ?? 0);
        $history = (string) ($this->request->getGet('status') ?? '') === 'true';
        if ($tahun <= 0 || $rencanaId <= 0) {
            return redirect()->to(base_url('eksekutif/laporan'));
        }
        $rencana = null;
        $bulan6 = [];$bulan12 = [];$ringkasan6 = [];$ringkasan12 = [];$indikatorCount = 0;
        $isDebug = in_array(strtolower((string)($this->request->getGet('debug') ?? '')), ['1','true','yes'], true);
        try {
            $db = db_connect();
            $rencana = $db->table('rencana')->select('id, kode, aksi')->where('id', $rencanaId)->get()->getRowArray();
            // indikator count for this rencana
            $indikatorCount = (int) $db->table('indikator')->where('rencana_id', $rencanaId)->countAllResults();

            // Helper to build generateLaporan-like data for a given bulan snapshot (6 or 12)
            $buildGenerate = function(int $bulan) use ($db, $rencanaId, $tahun) {
                $qb = $db->table('pelaksana p')
                    ->select('l1.level1 as level1, l2.level2 as level2, l3.level3 as level3, w.wilayah as wilayah, k.progress, k.tahun, k.bulan, k.keberhasilan, SUM(IF(k.status_eval = 2, k.progress, 0)) as total_progress, p.id as pelaksana_id, k.id as keb_id', false)
                    ->join('keberhasilan k', 'k.pelaksana_id = p.id', 'right')
                    ->join('indikator i', 'i.id = k.indikator_id', 'left')
                    ->join('level1 l1', 'l1.id = p.level1_id', 'left')
                    ->join('level2 l2', 'l2.id = p.level2_id', 'left')
                    ->join('level3 l3', 'l3.id = p.level3_id', 'left')
                    ->join('wilayah w', 'w.id = l2.wilayah_id', 'left')
                    ->where('i.rencana_id', $rencanaId)
                    ->where(['k.tahun' => $tahun, 'k.bulan' => $bulan])
                    ->groupStart()->where('k.status_eval !=', 0)->groupEnd()
                    // Admin-wide scope: level1 in (1..6)
                    ->whereIn('l1.id', [1,2,3,4,5,6])
                    ->groupBy('p.id')
                    ->orderBy('total_progress', 'DESC')
                    ->groupBy('k.tahun')
                    ->groupBy('k.bulan');
                $sub = $qb->getCompiledSelect();
                $rows = $db->table("($sub) as permohonan")
                    ->select('level1, level2, level3, progress, tahun, bulan, keberhasilan, total_progress, pelaksana_id, keb_id')
                    ->get()->getResultArray();
                return $rows;
            };
            $bulan6 = $buildGenerate(6);
            $bulan12 = $buildGenerate(12);

            // Build ringkasan
            $buildRingkasan = function(array $generated) {
                $total = [];
                $melapor = [];
                foreach ($generated as $row) {
                    $lvl = (string)($row['level1'] ?? '');
                    if ($lvl==='') continue;
                    $total[$lvl] = ($total[$lvl] ?? 0) + 1;
                    $tp = (int)($row['total_progress'] ?? 0);
                    if ($tp > 0) { $melapor[$lvl] = ($melapor[$lvl] ?? 0) + 1; }
                }
                $keys = array_unique(array_merge(array_keys($total), array_keys($melapor)));
                $out = [];
                foreach ($keys as $k) {
                    $tot = (int)($total[$k] ?? 0);
                    $mel = (int)($melapor[$k] ?? 0);
                    $persen = $tot > 0 ? round($mel * 10000 / $tot) / 100 : 0.0;
                    $out[] = ['level1' => $k, 'total' => $tot, 'melapor' => $mel, 'persen' => $persen];
                }
                usort($out, function($a,$b){ return strcmp($a['level1'], $b['level1']); });
                return $out;
            };
            $ringkasan6 = $buildRingkasan($bulan6);
            $ringkasan12 = $buildRingkasan($bulan12);
        } catch (\Throwable $e) { $bulan6=[]; $bulan12=[]; $ringkasan6=[]; $ringkasan12=[]; }
        if ($isDebug) {
            try {
                $db = db_connect();
                $raw6 = $db->table('keberhasilan k')->join('indikator i','i.id=k.indikator_id','left')->where('i.rencana_id',$rencanaId)->where('k.tahun',$tahun)->where('k.bulan',6)->countAllResults();
                $raw12 = $db->table('keberhasilan k')->join('indikator i','i.id=k.indikator_id','left')->where('i.rencana_id',$rencanaId)->where('k.tahun',$tahun)->where('k.bulan',12)->countAllResults();
            } catch (\Throwable $e) { $raw6=0; $raw12=0; }
            return $this->response->setJSON([
                'tahun' => $tahun,
                'rencana_id' => $rencanaId,
                'rencana' => $rencana,
                'counts' => [
                    'bulan6' => is_array($bulan6) ? count($bulan6) : 0,
                    'bulan12' => is_array($bulan12) ? count($bulan12) : 0,
                    'ringkasan6' => is_array($ringkasan6) ? count($ringkasan6) : 0,
                    'ringkasan12' => is_array($ringkasan12) ? count($ringkasan12) : 0,
                    'indikator' => $indikatorCount,
                    'raw_keberhasilan_bulan6' => $raw6,
                    'raw_keberhasilan_bulan12' => $raw12,
                ],
                'sample' => [
                    'bulan6_first' => $bulan6[0] ?? null,
                    'bulan12_first' => $bulan12[0] ?? null,
                    'ringkasan6' => $ringkasan6,
                    'ringkasan12' => $ringkasan12,
                ],
            ]);
        }
        return view('admin/laporan/detail', [
            'tahun' => $tahun,
            'rencana' => $rencana,
            'bulan6' => $bulan6,
            'bulan12' => $bulan12,
            'ringkasan6' => $ringkasan6,
            'ringkasan12' => $ringkasan12,
            'indikator' => $indikatorCount,
        ]);
    }

    public function getAll()
    {
        $tahun = (int) ($this->request->getPost('tahun') ?? date('Y'));
        $rencanaID = (int) ($this->request->getPost('rencana_id') ?? 0);
        $status = (string) ($this->request->getPost('status') ?? '');
        $rows = [];
        try {
            $db = db_connect();
            $b = $db->table('keberhasilan');
            $b->select('id, judul, status_eval as status, updated_at');
            if ($tahun) $b->where('YEAR(updated_at)', $tahun);
            if ($rencanaID) $b->where('rencana_id', $rencanaID);
            if ($status !== '') $b->where('status_eval', $status);
            $rows = $b->get()->getResultArray();
        } catch (\Throwable $e) {
            $rows = [];
        }
        return $this->response->setStatusCode(200)->setJSON([
            'data' => $rows,
        ]);
    }

    

    public function data_dukung(int $keberhasilanId)
    {
        $row = null;
        try {
            $db = db_connect();
            $row = $db->table('dukung d')->select('d.*, s.nama as satuan_nama')
                ->join('satuan s', 's.id = d.satuan', 'left')
                ->where('d.keberhasilan_id', $keberhasilanId)
                ->get()->getRowArray();
        } catch (\Throwable $e) {
            $row = null;
        }
        return $this->response->setJSON($row ?: []);
    }

    public function changeStatus()
    {
        $id = (int) ($this->request->getPost('id') ?? 0);
        $status = (string) ($this->request->getPost('status') ?? '');
        $catatan = (string) ($this->request->getPost('catatan') ?? '');
        $ok = false;
        try {
            $db = db_connect();
            $row = $db->table('keberhasilan')->where('id', $id)->get()->getRowArray();
            if ($row) {
                $data = [ 'status_eval' => $status ];
                if (!empty($row['catatan_eval'])) {
                    if ($catatan !== '') {
                        $db->table('catatan')->insert(['keberhasilan_id' => $id, 'catatan_eval' => $catatan]);
                    }
                } else {
                    if ($catatan !== '') $data['catatan_eval'] = $catatan;
                }
                $db->table('keberhasilan')->where('id', $id)->update($data);
                $ok = true;
            }
        } catch (\Throwable $e) {
            $ok = false;
        }
        return $this->response->setJSON(['status' => $ok]);
    }

    public function debug()
    {
        try {
            $db = db_connect();
            $roleId = (int) (session('role_id') ?? 0);
            $roleStr = strtolower((string) (session('role') ?? ''));
            $parts = explode(' ', $roleStr);
            $last = end($parts);
            $suffix = trim(strtolower($last ?: ''));
            $level2Id = (int) (session('level2') ?? 0);
            $wilayahId = (int) (session('wilayah') ?? 0);

            $A = $this->buildTahunHistory($db, $roleId, $suffix, $level2Id, $wilayahId, true);
            $B = $this->buildTahunHistorySetEval($db, $roleId, $suffix, $level2Id, $wilayahId, true);
            $C = $this->buildTahunHistory($db, $roleId, $suffix, $level2Id, $wilayahId, false);
            $D = $this->buildTahunHistoryNoRole($db, $suffix, $level2Id, $wilayahId, true);
            $E = $this->buildRencanaYearCounts($db);
            $F = $this->buildAnyYearCounts($db);

            // Basic schema diagnostics
            $tables = $db->listTables();
            $counts = [];
            foreach (['keberhasilan','rencana','indikator','pelaksana','set_eval','level2'] as $t) {
                try { $counts[$t] = (int) $db->table($t)->countAllResults(); } catch (\Throwable $e) { $counts[$t] = 'missing'; }
            }
            $samples = [];
            foreach (['keberhasilan','rencana'] as $t) {
                try { $samples[$t] = $db->table($t)->limit(3)->get()->getResultArray(); } catch (\Throwable $e) { $samples[$t] = []; }
            }

            return $this->response->setJSON([
                'session' => [
                    'role_id' => $roleId,
                    'role' => $roleStr,
                    'suffix' => $suffix,
                    'level2' => $level2Id,
                    'wilayah' => $wilayahId,
                ],
                'A_strict_keberhasilan_role_region_status' => $A,
                'B_set_eval_role_mapping' => $B,
                'C_no_status_filter_keep_role' => $C,
                'D_no_role_keep_status' => $D,
                'E_rencana_counts' => $E,
                'F_any_year_counts' => $F,
                'tables' => $tables,
                'table_counts' => $counts,
                'samples' => $samples,
            ]);
        } catch (\Throwable $e) {
            return $this->response->setStatusCode(500)->setJSON(['error' => $e->getMessage()]);
        }
    }

    private function buildTahunHistory($db, int $roleId, string $suffix, int $level2Id, int $wilayahId, bool $exclude01): array
    {
        try {
            $qb = $db->table('keberhasilan k')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('level2 l2', 'l2.id = p.level2_id', 'left')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->select('COALESCE(r.tahun, k.tahun, YEAR(k.updated_at)) as tahun', false)
                ->select('COUNT(*) as jumlah', false);
            if ($exclude01) {
                $qb->where('COALESCE(CAST(k.status_eval AS CHAR), k.status, k.state) NOT IN ("0","1")', null, false);
            }
            if ($roleId) {
                $qb->where('r.role_id', $roleId);
            }
            if ($suffix === 'kab/kota' && $level2Id) {
                $qb->where('p.level2_id', $level2Id);
            } elseif ($suffix === 'provinsi' && $wilayahId) {
                $qb->where('l2.wilayah_id', $wilayahId);
            }
            $qb->groupBy('COALESCE(r.tahun, k.tahun, YEAR(k.updated_at))', false)
               ->orderBy('tahun', 'DESC');
            $rows = $qb->get()->getResultArray();
            return array_map(static function($r){
                return [
                    'tahun' => isset($r['tahun']) ? (int)$r['tahun'] : (int)date('Y'),
                    'jumlah' => (int)($r['jumlah'] ?? 0),
                ];
            }, $rows ?? []);
        } catch (\Throwable $e) {
            return [];
        }
    }

    private function buildTahunHistorySetEval($db, int $roleId, string $suffix, int $level2Id, int $wilayahId, bool $exclude01): array
    {
        try {
            $qb = $db->table('keberhasilan k')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('level2 l2', 'l2.id = p.level2_id', 'left')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->select('COALESCE(r.tahun, k.tahun, YEAR(k.updated_at)) as tahun', false)
                ->select('COUNT(*) as jumlah', false);
            if ($exclude01) {
                $qb->where('COALESCE(CAST(k.status_eval AS CHAR), k.status, k.state) NOT IN ("0","1")', null, false);
            }
            if ($roleId) {
                $qb->where('se.role_id', $roleId);
            }
            if ($suffix === 'kab/kota' && $level2Id) {
                $qb->where('p.level2_id', $level2Id);
            } elseif ($suffix === 'provinsi' && $wilayahId) {
                $qb->where('l2.wilayah_id', $wilayahId);
            }
            $qb->groupBy('COALESCE(r.tahun, k.tahun, YEAR(k.updated_at))', false)
               ->orderBy('tahun', 'DESC');
            $rows = $qb->get()->getResultArray();
            return array_map(static function($r){
                return [
                    'tahun' => isset($r['tahun']) ? (int)$r['tahun'] : (int)date('Y'),
                    'jumlah' => (int)($r['jumlah'] ?? 0),
                ];
            }, $rows ?? []);
        } catch (\Throwable $e) {
            return [];
        }
    }

    private function buildTahunHistoryNoRole($db, string $suffix, int $level2Id, int $wilayahId, bool $exclude01): array
    {
        try {
            $qb = $db->table('keberhasilan k')
                ->join('pelaksana p', 'p.id = k.pelaksana_id', 'left')
                ->join('level2 l2', 'l2.id = p.level2_id', 'left')
                ->select('COALESCE(k.tahun, YEAR(k.updated_at)) as tahun', false)
                ->select('COUNT(*) as jumlah', false);
            if ($exclude01) {
                $qb->where('COALESCE(CAST(k.status_eval AS CHAR), k.status, k.state) NOT IN ("0","1")', null, false);
            }
            if ($suffix === 'kab/kota' && $level2Id) {
                $qb->where('p.level2_id', $level2Id);
            } elseif ($suffix === 'provinsi' && $wilayahId) {
                $qb->where('l2.wilayah_id', $wilayahId);
            }
            $qb->groupBy('COALESCE(k.tahun, YEAR(k.updated_at))', false)
               ->orderBy('tahun', 'DESC');
            $rows = $qb->get()->getResultArray();
            return array_map(static function($r){
                return [
                    'tahun' => isset($r['tahun']) ? (int)$r['tahun'] : (int)date('Y'),
                    'jumlah' => (int)($r['jumlah'] ?? 0),
                ];
            }, $rows ?? []);
        } catch (\Throwable $e) {
            return [];
        }
    }

    private function buildRencanaYearCounts($db): array
    {
        try {
            $rows = $db->table('rencana')
                ->select('tahun, COUNT(*) as jumlah')
                ->where('tahun IS NOT NULL', null, false)
                ->groupBy('tahun')
                ->orderBy('tahun', 'DESC')
                ->get()->getResultArray();
            return array_map(static function($r){
                return [
                    'tahun' => isset($r['tahun']) ? (int)$r['tahun'] : (int)date('Y'),
                    'jumlah' => (int)($r['jumlah'] ?? 0),
                ];
            }, $rows ?? []);
        } catch (\Throwable $e) {
            return [];
        }
    }

    private function buildAnyYearCounts($db): array
    {
        try {
            $rows = $db->table('keberhasilan k')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->select('COALESCE(r.tahun, k.tahun, YEAR(k.updated_at), YEAR(k.created_at), YEAR(r.created_at)) as tahun', false)
                ->select('COUNT(*) as jumlah', false)
                ->groupBy('COALESCE(r.tahun, k.tahun, YEAR(k.updated_at), YEAR(k.created_at), YEAR(r.created_at))', false)
                ->orderBy('tahun', 'DESC')
                ->get()->getResultArray();
            return array_map(static function($r){
                return [
                    'tahun' => isset($r['tahun']) ? (int)$r['tahun'] : (int)date('Y'),
                    'jumlah' => (int)($r['jumlah'] ?? 0),
                ];
            }, $rows ?? []);
        } catch (\Throwable $e) {
            return [];
        }
    }

    private function buildCountsByKeberhasilanWithSetEval($db, int $roleId): array
    {
        try {
            $qb = $db->table('keberhasilan k')
                ->join('indikator i', 'i.id = k.indikator_id', 'left')
                ->join('rencana r', 'r.id = i.rencana_id', 'left')
                ->join('set_eval se', 'se.set = r.kode', 'left')
                ->select('k.tahun as tahun', false)
                ->select('COUNT(DISTINCT k.id) as jumlah', false)
                ->where('k.tahun IS NOT NULL', null, false)
                ->where('k.tahun <> ""', null, false)
                ->groupStart()
                    ->where('k.status_eval', 2)
                    ->orWhere('k.status', '2')
                ->groupEnd();
            if ($roleId) {
                $qb->where('se.role_id', $roleId);
            }
            $rows = $qb->groupBy('k.tahun')
                       ->orderBy('tahun', 'DESC')
                       ->get()->getResultArray();
            return array_map(static function($r){
                return [
                    'tahun' => isset($r['tahun']) ? (int)$r['tahun'] : (int)date('Y'),
                    'jumlah' => (int)($r['jumlah'] ?? 0),
                ];
            }, $rows ?? []);
        } catch (\Throwable $e) {
            return [];
        }
    }
}
