<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Rencana Laporan',
  'active' => 'laporan',
  'breadcrumb' => ['Eksekutif','Laporan','Rencana']
]) ?>
    <div class="bg-white rounded-2xl shadow p-6">
      <div class="flex items-center justify-between mb-3">
        <div class="text-slate-700">Tahun: <strong><?= esc($tahun ?? '') ?></strong> <?= $status ? '(Status: '.esc($status).')' : '' ?></div>
        <a href="<?= base_url('eksekutif/laporan') ?>" class="text-sm text-indigo-600 hover:underline">Kembali</a>
      </div>
      <div class="overflow-x-auto">
        <table class="min-w-full text-sm">
          <thead class="bg-slate-50">
            <tr>
              <th class="px-3 py-2 text-left">ID</th>
              <th class="px-3 py-2 text-left">Judul</th>
              <th class="px-3 py-2 text-left">Tahun</th>
              <th class="px-3 py-2 text-left">Status</th>
              <th class="px-3 py-2 text-left">Aksi</th>
            </tr>
          </thead>
          <tbody class="bg-white divide-y">
            <?php foreach (($rencana ?? []) as $r): ?>
              <tr>
                <td class="px-3 py-2"><?= (int)($r['id'] ?? 0) ?></td>
                <td class="px-3 py-2"><?= esc($r['judul'] ?? '-') ?></td>
                <td class="px-3 py-2"><?= esc($r['tahun'] ?? '-') ?></td>
                <td class="px-3 py-2"><?= esc($r['status'] ?? '-') ?></td>
                <td class="px-3 py-2">
                  <a class="text-indigo-600 hover:underline" href="<?= base_url('eksekutif/laporan/detail?rencana_id='.(int)($r['id']??0).'&tahun='.(int)($r['tahun']??0)) ?>">Detail</a>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (empty($rencana ?? [])): ?>
              <tr><td colspan="5" class="px-3 py-6 text-center text-slate-500">Tidak ada data</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
<?= view('layouts/dashboard_footer') ?>
