<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Dashboard',
  'active' => 'dashboard',
  'breadcrumb' => ['Evaluator','Dashboard']
]) ?>

<div class="px-4 sm:px-6 lg:px-8">
  <style>
    .stat-card{border-radius:16px; overflow:hidden; box-shadow:0 6px 16px rgba(2,8,20,.06); min-height:110px}
    .stat-card .body{padding:18px 20px}
    .stat-card .value{font-size:32px; line-height:1; font-weight:800; color:#fff}
    .stat-card .label{margin-top:8px; font-size:14px; font-weight:600; color:#eef2ff}
  </style>
  <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mt-4">
    <div class="stat-card" style="background-color:#17a2b8">
      <div class="body">
        <div class="value"><?= (int)($permohonan ?? 0) ?></div>
        <div class="label">Permohonan Masuk</div>
      </div>
    </div>
    <div class="stat-card" style="background-color:#28a745">
      <div class="body">
        <div class="value"><?= (int)($permohonan_history ?? 0) ?></div>
        <div class="label">Permohonan History</div>
      </div>
    </div>
    <div class="stat-card" style="background-color:#dc3545">
      <div class="body">
        <div class="value"><?= (int)($progress ?? 0) ?></div>
        <div class="label">Progress Masuk</div>
      </div>
    </div>
    <div class="stat-card" style="background-color:#ffc107">
      <div class="body">
        <div class="value" style="color:#111827"><?= (int)($progress_history ?? 0) ?></div>
        <div class="label" style="color:#1f2937">Progress History</div>
      </div>
    </div>
  </div>

  <div class="bg-white rounded-2xl shadow p-6 mt-6">
    <h5 class="text-base font-semibold">Progress Masuk</h5>
    <p class="text-sm text-slate-500">lihat progress bulanan untuk di evaluasi</p>
    <?php if (!empty($notifikasi ?? [])): ?>
      <div class="mt-6 space-y-6">
        <?php foreach (($notifikasi ?? []) as $val): ?>
          <a class="block" href="<?= site_url('evaluator/laporan/'). 'detail?tahun='.(int)($val['tahun'] ?? 0).'&rencana_id='.(int)($val['rencana_id'] ?? 0).'&status=' ?>">
            <div class="flex items-start gap-3">
              <div class="mt-1 w-2 h-2 rounded-full bg-slate-400"></div>
              <div class="flex-1">
                <?php $pel = array_filter([$val['level1'] ?? null, $val['level2'] ?? null, $val['level3'] ?? null]); ?>
                <div class="text-slate-600 font-medium">
                  <?= esc((string)end($pel)) ?>
                  <span class="float-right text-xs text-slate-500"><?= esc(date('d M Y', strtotime((string)($val['tanggal_progres'] ?? date('Y-m-d'))))) ?></span>
                </div>
                <div class="text-slate-600 mt-2">
                  <div class="font-medium"><?= esc((string)($val['program'] ?? '-')) ?></div>
                  <p class="mt-1"><?= esc((string)($val['aksi'] ?? '-')) ?></p>
                </div>
              </div>
            </div>
          </a>
        <?php endforeach; ?>
      </div>
    <?php else: ?>
      <div class="text-center py-10">
        <img src="<?= base_url('source/none.svg'); ?>" alt="empty" class="mx-auto w-56">
        <div class="mt-5">
          <h5 class="text-slate-700 font-semibold">Tidak ada progres masuk</h5>
          <p class="text-slate-500 text-sm">Setelah progres di setujui / ditolak maka data akan hilang dari notifikasi</p>
        </div>
      </div>
    <?php endif; ?>
  </div>
</div>

<?= view('layouts/dashboard_footer') ?>
