<?= view('layouts/dashboard_header', [
  'title' => $title ?? 'Laporan - Rencana',
  'active' => 'laporan',
  'breadcrumb' => $breadcrumb ?? ['Admin','Laporan','Rencana']
]) ?>

<div class="bg-white rounded-2xl shadow p-6 mt-6">
  <?php
    $headers = [
      ['key' => 'no', 'label' => 'No', 'noSort' => true],
      ['key' => 'kode', 'label' => 'Kode'],
      ['key' => 'aksi', 'label' => 'Rencana Aksi'],
      ['key' => 'jumlah', 'label' => 'Jumlah Aksi', 'align' => 'right'],
    ];
    $prefixBase = isset($basePrefix) && $basePrefix ? $basePrefix : 'admin';
    $backHref = base_url($prefixBase.'/periode');
    echo '<div class="flex items-center gap-2 mb-1">'
        . '<a href="'.esc($backHref).'" class="inline-flex items-center justify-center w-8 h-8 rounded-md border border-slate-200 text-slate-600 hover:bg-slate-50" title="Kembali">'
        . '<svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"/><path d="M20 12H9"/></svg>'
        . '</a>'
        . '<h2 class="text-lg font-semibold">Rencana History '.esc($tahun).'</h2>'
        . '</div>';
    echo '<p class="text-sm text-slate-500 mb-4">Anda dapat memilih laporan berdasarkan field di bawah</p>';
    $tableRows = array_map(function($v) use ($tahun, $prefixBase){
      $rid = (string)($v['rencana_id'] ?? '0');
      $href = base_url($prefixBase.'/laporan/detail').'?tahun='.urlencode((string)$tahun).'&rencana_id='.urlencode($rid).'&status=true';
      return [
        '_href' => $href,
        'kode' => '<a class="text-sky-700 hover:underline" href="'.esc($href).'">'.esc((string)($v['kode'] ?? '-')).'</a>',
        'aksi' => (string)($v['aksi'] ?? '-'),
        'jumlah' => (string)($v['jumlah'] ?? '0'),
      ];
    }, $rows ?? []);
    echo view('components/data-table', [
      'id' => 'dt_rencana',
      'headers' => array_map(function($h){ $k=$h['key']??''; if($k==='kode'){ $h['raw']=true; } return $h; }, $headers),
      'rows' => $tableRows,
      'pageSize' => 10,
      'rowLink' => true,
    ]);
  ?>
</div>

<?= view('layouts/dashboard_footer') ?>
