<?= view('layouts/dashboard_header', [
  'title' => 'Setting',
  'active' => 'dashboard',
  'breadcrumb' => ['Admin','Setting']
]) ?>

  <?php if (session()->getFlashdata('success')): ?>
    <div class="mb-4 p-3 rounded bg-emerald-50 text-emerald-700 border border-emerald-200">
      <?= esc(session()->getFlashdata('success')) ?>
    </div>
  <?php endif; ?>
  <?php if (session()->getFlashdata('error')): ?>
    <div class="mb-4 p-3 rounded bg-rose-50 text-rose-700 border border-rose-200">
      <?= esc(session()->getFlashdata('error')) ?>
    </div>
  <?php endif; ?>

  <div class="bg-white rounded-2xl shadow p-6">
    <div>
      <h2 class="text-lg font-semibold">Setting <?= esc(date('d-M-Y')) ?></h2>
      <p class="text-sm text-slate-500">Setting periode untuk penginputan rencana user</p>
    </div>

    <?php $months = [
      1=>'Januari', 2=>'Februari', 3=>'Maret', 4=>'April', 5=>'Mei', 6=>'Juni',
      7=>'Juli', 8=>'Agustus', 9=>'September', 10=>'Oktober', 11=>'November', 12=>'Desember'];
    ?>

    <div class="mt-6">
      <div class="flex border-b text-sm">
        <button type="button" data-tab="pelaporan" class="tab-btn px-4 py-2 border-b-2 border-indigo-600 text-indigo-600">Pelaporan</button>
        <button type="button" data-tab="revisi" class="tab-btn px-4 py-2 border-b-2 border-transparent text-slate-600">Revisi</button>
      </div>
    </div>

    <div id="tab_pelaporan" class="pt-4">
      <form method="post" action="<?= site_url('admin/setting/update') ?>" class="space-y-5">
        <?= csrf_field() ?>
        <?php 
          $p = [ (array)($t1 ?? []), (array)($t2 ?? []) ];
          $labels = ['Bulan 6','Bulan 12'];
        ?>
        <?php foreach ($p as $i => $row): ?>
          <div class="border rounded-xl p-4">
            <div class="font-medium text-slate-700 mb-3"><?= esc($labels[$i]) ?></div>
            <div class="grid grid-cols-2 sm:grid-cols-6 gap-3 items-end">
              <div>
                <label class="block text-xs text-slate-600 mb-1">Tanggal Awal</label>
                <input name="tanggal1[]" type="number" min="1" max="31" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string)($row['tgl1'] ?? '')) ?>">
              </div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Bulan Awal</label>
                <select name="bulan1[]" class="w-full border rounded-lg px-3 py-2">
                  <?php foreach ($months as $m => $label): ?>
                    <option value="<?= $m ?>" <?= (isset($row['bulan1']) && (int)$row['bulan1']===$m)?'selected':''; ?>><?= esc($label) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Tahun Awal</label>
                <input name="tahun1[]" type="number" min="2000" max="2100" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string)($row['tahun1'] ?? '')) ?>">
              </div>
              <div class="text-center text-slate-500">S / D</div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Tanggal Akhir</label>
                <input name="tanggal2[]" type="number" min="1" max="31" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string)($row['tgl2'] ?? '')) ?>">
              </div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Bulan Akhir</label>
                <select name="bulan2[]" class="w-full border rounded-lg px-3 py-2">
                  <?php foreach ($months as $m => $label): ?>
                    <option value="<?= $m ?>" <?= (isset($row['bulan2']) && (int)$row['bulan2']===$m)?'selected':''; ?>><?= esc($label) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Tahun Akhir</label>
                <input name="tahun2[]" type="number" min="2000" max="2100" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string)($row['tahun2'] ?? '')) ?>">
              </div>
            </div>
          </div>
        <?php endforeach; ?>

        <div class="flex items-center justify-between pt-2">
          <label class="inline-flex items-center gap-2 text-sm">
            <?php $isActive = (int)($t1['is_active'] ?? 0); ?>
            <input type="checkbox" name="check" value="1" <?= $isActive ? 'checked' : '' ?> class="rounded border-slate-300">
            <span>Jika periode 12 dan tahun baru</span>
          </label>
          <button type="submit" class="px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">Simpan Perubahan</button>
        </div>
      </form>
    </div>

    <div id="tab_revisi" class="pt-4 hidden">
      <form method="post" action="<?= site_url('admin/setting/update_revisi') ?>" class="space-y-5">
        <?= csrf_field() ?>
        <?php 
          $r = [ (array)($t1_revisi ?? []), (array)($t2_revisi ?? []) ];
          $labels = ['Bulan 6','Bulan 12'];
        ?>
        <?php foreach ($r as $i => $row): ?>
          <div class="border rounded-xl p-4">
            <div class="font-medium text-slate-700 mb-3"><?= esc($labels[$i]) ?></div>
            <div class="grid grid-cols-2 sm:grid-cols-6 gap-3 items-end">
              <div>
                <label class="block text-xs text-slate-600 mb-1">Tanggal Awal</label>
                <input name="tanggal1[]" type="number" min="1" max="31" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string)($row['tgl1'] ?? '')) ?>">
              </div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Bulan Awal</label>
                <select name="bulan1[]" class="w-full border rounded-lg px-3 py-2">
                  <?php foreach ($months as $m): ?>
                    <option value="<?= $m ?>" <?= (isset($row['bulan1']) && (int)$row['bulan1']===$m)?'selected':''; ?>><?= $m ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Tahun Awal</label>
                <input name="tahun1[]" type="number" min="2000" max="2100" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string)($row['tahun1'] ?? '')) ?>">
              </div>
              <div class="text-center text-slate-500">S / D</div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Tanggal Akhir</label>
                <input name="tanggal2[]" type="number" min="1" max="31" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string)($row['tgl2'] ?? '')) ?>">
              </div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Bulan Akhir</label>
                <select name="bulan2[]" class="w-full border rounded-lg px-3 py-2">
                  <?php foreach ($months as $m): ?>
                    <option value="<?= $m ?>" <?= (isset($row['bulan2']) && (int)$row['bulan2']===$m)?'selected':''; ?>><?= $m ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div>
                <label class="block text-xs text-slate-600 mb-1">Tahun Akhir</label>
                <input name="tahun2[]" type="number" min="2000" max="2100" class="w-full border rounded-lg px-3 py-2" value="<?= esc((string)($row['tahun2'] ?? '')) ?>">
              </div>
            </div>
          </div>
        <?php endforeach; ?>

        <div class="flex items-center justify-end pt-2">
          <button type="submit" class="px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">Simpan Perubahan</button>
        </div>
      </form>
    </div>
  </div>

  <script>
    (function(){
      var tabs = document.querySelectorAll('.tab-btn');
      function show(tab){
        document.getElementById('tab_pelaporan').classList.toggle('hidden', tab!=='pelaporan');
        document.getElementById('tab_revisi').classList.toggle('hidden', tab!=='revisi');
        tabs.forEach(function(btn){
          var active = btn.getAttribute('data-tab')===tab;
          btn.classList.toggle('border-indigo-600', active);
          btn.classList.toggle('text-indigo-600', active);
          btn.classList.toggle('border-transparent', !active);
          btn.classList.toggle('text-slate-600', !active);
        });
      }
      tabs.forEach(function(btn){ btn.addEventListener('click', function(){ show(btn.getAttribute('data-tab')); }); });
      show('pelaporan');
    })();
  </script>
