<?php
use Config\Menu as MenuConfig;

$items = MenuConfig::forCurrentUser();
?>
<nav class="w-full bg-white/80 backdrop-blur border-b border-slate-200">
  <div class="max-w-6xl mx-auto px-4">
    <ul class="flex gap-4 py-3 text-sm">
      <?php foreach ($items as $item): ?>
        <?php if (!empty($item['children'])): ?>
          <li class="relative group">
            <span class="cursor-default text-slate-700 hover:text-indigo-700 font-medium">
              <?= esc($item['label']) ?>
            </span>
            <div class="absolute hidden group-hover:block bg-white shadow-md rounded-md mt-2 p-2 z-10 min-w-[12rem] border border-slate-200">
              <?php foreach ($item['children'] as $child): ?>
                <a class="block px-3 py-1.5 rounded hover:bg-slate-50 text-slate-700" href="<?= esc($child['href']) ?>">
                  <?= esc($child['label']) ?>
                </a>
              <?php endforeach; ?>
            </div>
          </li>
        <?php else: ?>
          <li>
            <a class="text-slate-700 hover:text-indigo-700 font-medium" href="<?= esc($item['href']) ?>">
              <?= esc($item['label']) ?>
            </a>
          </li>
        <?php endif; ?>
      <?php endforeach; ?>
    </ul>
  </div>
</nav>
