<?php
// $title, $subtitle, $actions (array), $body (html), $footer (html)
?>
<div class="bg-white rounded-2xl shadow border border-slate-200">
  <div class="px-4 sm:px-5 py-4 border-b border-slate-200 flex items-center justify-between">
    <div>
      <?php if (!empty($title)): ?>
        <h3 class="text-base sm:text-lg font-semibold text-slate-800"><?= esc($title) ?></h3>
      <?php endif; ?>
      <?php if (!empty($subtitle)): ?>
        <div class="text-xs sm:text-sm text-slate-500 mt-0.5"><?= esc($subtitle) ?></div>
      <?php endif; ?>
    </div>
    <?php if (!empty($actions)): ?>
      <div class="flex items-center gap-2">
        <?php foreach ($actions as $a): ?>
          <a href="<?= esc($a['href'] ?? '#') ?>" class="inline-flex items-center gap-2 rounded-xl border border-slate-200 hover:bg-slate-50 text-slate-700 text-xs sm:text-sm px-3 py-2">
            <?php if (!empty($a['icon'])): ?>
            <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="<?= $a['icon'] ?>"/></svg>
            <?php endif; ?>
            <span><?= esc($a['label'] ?? 'Action') ?></span>
          </a>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
  <div class="p-4 sm:p-5">
    <?= $body ?? '' ?>
  </div>
  <?php if (!empty($footer)): ?>
  <div class="px-4 sm:px-5 py-3 border-t border-slate-200 text-xs text-slate-500">
    <?= $footer ?>
  </div>
  <?php endif; ?>
</div>
