<aside class="hidden md:flex md:w-64 lg:w-72 xl:w-80 flex-col border-r border-slate-200 bg-white/90 backdrop-blur">
  <div class="h-16 flex items-center px-6 border-b border-slate-200">
    <a href="<?= base_url('/') ?>" class="text-indigo-600 font-extrabold tracking-wide">inpres<span class="text-slate-800">Dash</span></a>
  </div>
  <nav class="flex-1 overflow-y-auto py-4">
    <?php $active = $active ?? 'dashboard'; ?>
    <?php
      $items = [
        ['key' => 'dashboard', 'label' => 'Dashboard', 'href' => base_url('admin'), 'icon' => 'M3 12h18M12 3v18'],
        ['key' => 'users', 'label' => 'Users', 'href' => base_url('admin/users'), 'icon' => 'M15 11a3 3 0 11-6 0 3 3 0 016 0z M2 21a8 8 0 1116 0H2z'],
        ['key' => 'reports', 'label' => 'Reports', 'href' => base_url('admin/reports'), 'icon' => 'M4 6h16M4 12h16M4 18h16'],
        ['key' => 'settings', 'label' => 'Settings', 'href' => base_url('admin/settings'), 'icon' => 'M12 8a4 4 0 100 8 4 4 0 000-8z'],
      ];
    ?>
    <ul class="space-y-1 px-3">
      <?php foreach ($items as $it): $is = ($active === $it['key']); ?>
        <li>
          <a href="<?= $it['href'] ?>" class="group flex items-center gap-3 px-3 py-2 rounded-xl <?= $is ? 'bg-indigo-50 text-indigo-700' : 'text-slate-700 hover:bg-slate-50' ?>">
            <svg class="w-5 h-5 <?= $is ? 'text-indigo-600' : 'text-slate-400 group-hover:text-slate-600' ?>" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
              <path d="<?= $it['icon'] ?>" />
            </svg>
            <span class="text-sm font-medium"><?= esc($it['label']) ?></span>
          </a>
        </li>
      <?php endforeach; ?>
    </ul>
  </nav>
  <div class="p-4 border-t border-slate-200 text-xs text-slate-500">v1.0</div>
</aside>
