<header class="sticky top-0 z-30 bg-white/80 backdrop-blur border-b border-slate-200">
  <div class="h-16 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex items-center justify-between">
    <div class="flex items-center gap-3 min-w-0">
      <?php if (!empty($breadcrumb ?? [])): ?>
        <nav class="hidden sm:flex items-center gap-2 text-sm text-slate-500">
          <?php foreach (($breadcrumb ?? []) as $i => $bc): ?>
            <?php if ($i > 0): ?><span>/</span><?php endif; ?>
            <span class="<?= $i === count($breadcrumb) - 1 ? 'text-slate-900 font-semibold' : '' ?>"><?= esc($bc) ?></span>
          <?php endforeach; ?>
        </nav>
      <?php endif; ?>
    </div>
    <div class="flex items-center gap-2">
      <?php foreach (($actions ?? []) as $a): ?>
        <a href="<?= esc($a['href'] ?? '#') ?>" class="inline-flex items-center gap-2 rounded-xl bg-indigo-600 hover:bg-indigo-500 text-white text-sm px-3 py-2">
          <?php if (!empty($a['icon'])): ?>
            <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="<?= $a['icon'] ?>"/></svg>
          <?php endif; ?>
          <span><?= esc($a['label'] ?? 'Action') ?></span>
        </a>
      <?php endforeach; ?>
      <a href="<?= base_url('logout') ?>" class="inline-flex items-center gap-2 rounded-xl border border-slate-200 hover:bg-slate-50 text-slate-700 text-sm px-3 py-2">Logout</a>
    </div>
  </div>
</header>
