<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = session();
        $token = $session->get('access_token');
        $expiresAt = $session->get('token_expires_at');
        if (!$token) {
            return redirect()->to('/login');
        }
        if ($expiresAt && time() >= (int) $expiresAt) {
            $session->remove(['access_token', 'token_type', 'token_expires_in', 'token_expires_at', 'user_email']);
            return redirect()->to('/login');
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
    }
}
