<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<h3 class="mb-3">Report</h3>
<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= esc($error) ?></div>
<?php endif; ?>

<div class="card mb-3">
 <div class="card-header">Filter Data</div>
  <div class="card-body">
    <form method="get" action="/report">
      <input type="hidden" name="per_page" value="<?= esc((string) ($per_page ?? 10), 'attr') ?>">
      <div class="row g-3">
        <div class="col-md-4">
          <label for="start_date" class="form-label">Start date</label>
          <input type="date" id="start_date" name="start_date" class="form-control" value="<?= esc((string) ($start_date ?? ''), 'attr') ?>">
        </div>
        <div class="col-md-4">
          <label for="end_date" class="form-label">End date</label>
          <input type="date" id="end_date" name="end_date" class="form-control" value="<?= esc((string) ($end_date ?? ''), 'attr') ?>">
        </div>
        <div class="col-md-4 d-flex align-items-end">
          <button class="btn btn-primary me-2" type="submit">Filter</button>
          <a class="btn btn-outline-secondary me-2" href="/report">Reset</a>
          <button class="btn btn-success" type="submit" formmethod="get" formaction="/report/export">Export CSV</button>
        </div>
      </div>
    </form>
  </div>
</div>

<div class="card">
 <div class="card-body">
  <?php $start = max(0, ((int)($current_page ?? 1) - 1) * (int)($per_page ?? 10)); ?>
  <div class="table-responsive">
   <table class="table table-bordered table-sm align-middle">
     <thead>
       <tr>
         <th style="width:60px">No</th>
         <th>Regis #</th>
         <th>NIK</th>
         <th>Nama</th>
         <th>Tanggal</th>
         <th>To</th>
         <th>Room</th>
         <th>Floor</th>
         <th>Purpose</th>
         <th>Image</th>
       </tr>
     </thead>
     <tbody>
      <?php if (!empty($items) && is_array($items)): ?>
        <?php $i = 0; foreach ($items as $row): ?>
          <tr>
            <td><?= $start + (++$i) ?></td>
            <td><?= esc($row['regis_numbers'] ?? '') ?></td>
            <td><?= esc($row['nik'] ?? '') ?></td>
            <td><?= esc($row['name'] ?? '') ?></td>
            <td><?= esc($row['regis_date'] ?? '') ?></td>
            <td><?= esc($row['to'] ?? '') ?></td>
            <td><?= esc($row['room'] ?? '') ?></td>
            <td><?= esc($row['floor'] ?? '') ?></td>
            <td><?= esc($row['purpose'] ?? '') ?></td>
            <td>
              <?php if (!empty($row['image'])): ?>
                <img src="<?= esc($row['image'], 'attr') ?>" alt="img" style="max-width:80px;max-height:60px;object-fit:cover;" />
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
      <?php else: ?>
        <tr><td colspan="10" class="text-center">Tidak ada data.</td></tr>
      <?php endif; ?>
     </tbody>
   </table>
  </div>
 
  <?php 
    $totalPages = (int) ceil((int)($total ?? 0) / max(1, (int)($per_page ?? 10)));
    $totalPages = max(1, $totalPages);
    $current = (int)($current_page ?? 1);
    $prev = max(1, $current - 1);
    $next = min($totalPages, $current + 1);
    $qs = 'per_page=' . (int)($per_page ?? 10);
    if (!empty($start_date)) { $qs .= '&start_date=' . rawurlencode((string) $start_date); }
    if (!empty($end_date)) { $qs .= '&end_date=' . rawurlencode((string) $end_date); }
    $base = '/report?' . $qs . '&page=';
    $from = ($total ?? 0) > 0 ? ($start + 1) : 0;
    $to = min((int)($total ?? 0), $start + (is_array($items) ? count($items) : 0));
    // windowed pagination
    $window = 2; // show current ±2
    $startPage = max(1, $current - $window);
    $endPage = min($totalPages, $current + $window);
    if (($endPage - $startPage) < 4) {
      $lack = 4 - ($endPage - $startPage);
      $startPage = max(1, $startPage - $lack);
      $gapAfter = 4 - ($endPage - $startPage);
      if ($gapAfter > 0) { $endPage = min($totalPages, $endPage + $gapAfter); }
    }
  ?>
  <div class="d-flex justify-content-between align-items-center">
    <div>
      Menampilkan <?= esc((string) $from) ?>–<?= esc((string) $to) ?> dari <?= esc((string) ($total ?? 0)) ?> data
    </div>
    <nav>
      <ul class="pagination mb-0">
        <li class="page-item <?= $current <= 1 ? 'disabled' : '' ?>">
          <a class="page-link" href="<?= $base . $prev ?>">Prev</a>
        </li>
        <?php if ($startPage > 1): ?>
          <li class="page-item <?= $current === 1 ? 'active' : '' ?>">
            <a class="page-link" href="<?= $base ?>1">1</a>
          </li>
          <?php if ($startPage > 2): ?>
            <li class="page-item disabled"><span class="page-link">...</span></li>
          <?php endif; ?>
        <?php endif; ?>

        <?php for ($p = $startPage; $p <= $endPage; $p++): ?>
          <li class="page-item <?= $p === $current ? 'active' : '' ?>">
            <a class="page-link" href="<?= $base . $p ?>"><?= $p ?></a>
          </li>
        <?php endfor; ?>

        <?php if ($endPage < $totalPages): ?>
          <?php if ($endPage < $totalPages - 1): ?>
            <li class="page-item disabled"><span class="page-link">...</span></li>
          <?php endif; ?>
          <li class="page-item <?= $current === $totalPages ? 'active' : '' ?>">
            <a class="page-link" href="<?= $base . $totalPages ?>"><?= $totalPages ?></a>
          </li>
        <?php endif; ?>

        <li class="page-item <?= $current >= $totalPages ? 'disabled' : '' ?>">
          <a class="page-link" href="<?= $base . $next ?>">Next</a>
        </li>
      </ul>
    </nav>
  </div>
 </div>
</div>
<?= $this->endSection() ?>

